/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common.writers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public final class RateWriter
implements AutoCloseable {
    private static final int MICROS_PART_LENGTH = "000\"".length();
    private static final String DATE_FORMAT_PATTERN = "\"yyyy-MM-dd HH:mm:ss.SSS";
    public static final String TIMESTAMP_FORMAT = "\"yyyy-MM-dd HH:mm:ss.SSSSSS\"";
    public static final char SEPARATOR = ',';
    public static final int HEADER_LENGTH = "etd,atd".length();
    public static final int ESTIMATED_LINE_LENGTH = "\n\"yyyy-MM-dd HH:mm:ss.SSS,\"yyyy-MM-dd HH:mm:ss.SSS".length() + MICROS_PART_LENGTH * 2;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("\"yyyy-MM-dd HH:mm:ss.SSS");
    private final OutputStream outputStream;
    private final Date date = new Date();
    private final StringBuffer lineBuilder = new StringBuffer(ESTIMATED_LINE_LENGTH);
    private final byte[] writeBuffer = new byte[ESTIMATED_LINE_LENGTH];
    private final FieldPosition fullFieldPosition = new FieldPosition(0);
    private final File reportFile;

    public RateWriter(File reportFolder, boolean sender, boolean compressed) throws IOException {
        String secondTimeColumn;
        String firstTimeColumn;
        String role = sender ? "sender" : "receiver";
        String fileName = role + (compressed ? "d-rate.csv.gz" : "d-rate.csv");
        this.reportFile = new File(reportFolder, fileName);
        FileOutputStream fileStream = new FileOutputStream(this.reportFile);
        this.outputStream = compressed ? new GZIPOutputStream(fileStream) : fileStream;
        if (sender) {
            firstTimeColumn = "etd";
            secondTimeColumn = "atd";
        } else {
            firstTimeColumn = "eta";
            secondTimeColumn = "ata";
        }
        int encodedSize = RateWriter.encodeAscii(this.lineBuilder.append(firstTimeColumn).append(',').append(secondTimeColumn), this.writeBuffer);
        this.outputStream.write(this.writeBuffer, 0, encodedSize);
    }

    public File reportFile() {
        return this.reportFile;
    }

    public void write(long startTimeStampEpochMicros, long endTimeStampEpochMicros) {
        int encodedSize = RateWriter.encodeAscii(this.appendOn(startTimeStampEpochMicros, endTimeStampEpochMicros), this.writeBuffer);
        try {
            this.outputStream.write(this.writeBuffer, 0, encodedSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int digitOf(long microseconds) {
        int digits;
        if (microseconds < 10L) {
            digits = 1;
        } else if (microseconds < 100L) {
            digits = 2;
        } else {
            assert (microseconds < 1000L);
            digits = 3;
        }
        return digits;
    }

    private static StringBuffer appendDateMicros(long micros, StringBuffer buffer) {
        assert (micros >= 0L);
        if (micros == 0L) {
            buffer.append("000");
            return buffer;
        }
        int digits = RateWriter.digitOf(micros);
        int zerosPrefix = 3 - digits;
        switch (zerosPrefix) {
            case 1: {
                buffer.append("0");
                break;
            }
            case 2: {
                buffer.append("00");
            }
        }
        buffer.append(micros);
        return buffer;
    }

    private StringBuffer appendOn(long startTimeStampEpochMicros, long endTimeStampEpochMicros) {
        long startMillis = startTimeStampEpochMicros / 1000L;
        long startRemainingMicros = startTimeStampEpochMicros % 1000L;
        long endMillis = endTimeStampEpochMicros / 1000L;
        long endRemainingMicros = endTimeStampEpochMicros % 1000L;
        this.lineBuilder.setLength(0);
        this.lineBuilder.append('\n');
        this.date.setTime(startMillis);
        this.dateFormat.format(this.date, this.lineBuilder, this.fullFieldPosition);
        RateWriter.appendDateMicros(startRemainingMicros, this.lineBuilder).append('\"').append(',');
        this.date.setTime(endMillis);
        this.dateFormat.format(this.date, this.lineBuilder, this.fullFieldPosition);
        RateWriter.appendDateMicros(endRemainingMicros, this.lineBuilder).append('\"');
        return this.lineBuilder;
    }

    private static int encodeAscii(StringBuffer buffer, byte[] encodedBuffer) {
        int bufferLength = buffer.length();
        for (int i = 0; i < bufferLength; ++i) {
            char c = buffer.charAt(i);
            int b = c;
            if (b < 0) {
                b = 63;
            }
            encodedBuffer[i] = b;
        }
        return bufferLength;
    }

    @Override
    public void close() {
        try {
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

