/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common.duration;

import java.util.concurrent.TimeUnit;
import net.orpiske.mpt.common.duration.EpochMicroClock;
import net.orpiske.mpt.common.duration.JnaDirectNativeClock;
import net.orpiske.mpt.common.duration.ThreadLocalEpochMicroClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EpochClocks {
    private static final Logger LOGGER = LoggerFactory.getLogger(EpochClocks.class);
    private static final EpochMicroClock SHARED_CLOCK;
    private static final boolean SUPPORT_MICRO_CLOCKS;

    private static EpochMicroClock vanillaMillis() {
        return () -> TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
    }

    private EpochClocks() {
    }

    public static EpochMicroClock sharedMicro() {
        if (SUPPORT_MICRO_CLOCKS) {
            return SHARED_CLOCK;
        }
        return EpochClocks.vanillaMillis();
    }

    public static EpochMicroClock exclusiveMicro() {
        if (SUPPORT_MICRO_CLOCKS) {
            return new JnaDirectNativeClock();
        }
        return EpochClocks.vanillaMillis();
    }

    static {
        String OS_NAME = System.getProperty("os.name").toLowerCase();
        if (OS_NAME.indexOf("linux") >= 0) {
            SUPPORT_MICRO_CLOCKS = true;
            SHARED_CLOCK = new ThreadLocalEpochMicroClock(JnaDirectNativeClock::new);
        } else {
            SUPPORT_MICRO_CLOCKS = false;
            SHARED_CLOCK = null;
            LOGGER.warn("Microseconds precision clock is not supported: will be used the millis based on in place of it");
        }
    }
}

