/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common.content;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import net.orpiske.mpt.common.content.ContentStrategy;
import net.orpiske.mpt.common.content.MessageSize;

final class VariableSizeContent
implements ContentStrategy {
    private int lowerLimitInclusive = 0;
    private int upperLimitExclusive = 1;
    private ByteBuffer buffer = null;

    VariableSizeContent() {
    }

    public int minSize() {
        return this.lowerLimitInclusive;
    }

    public int maxSize() {
        return this.upperLimitExclusive - 1;
    }

    @Override
    public void setSize(int size) {
        int upperBoundExclusive;
        int lowerBoundInclusive;
        if (size >= 100) {
            int bound = size / 100 * 5;
            lowerBoundInclusive = size - bound + 1;
            upperBoundExclusive = size + bound + 1;
        } else {
            lowerBoundInclusive = size;
            upperBoundExclusive = size + 2;
        }
        if (lowerBoundInclusive < 8) {
            throw new IllegalStateException("The size is too small: please configure an bigger one");
        }
        this.lowerLimitInclusive = lowerBoundInclusive;
        this.upperLimitExclusive = upperBoundExclusive;
        int requiredCapacity = upperBoundExclusive - 1;
        this.buffer = ByteBuffer.allocate(requiredCapacity).order(CONTENT_ENDIANNESS);
        for (int i = 0; i < requiredCapacity; ++i) {
            this.buffer.put(i, (byte)i);
        }
    }

    @Override
    public void setSize(String sizeSpec) {
        this.setSize(MessageSize.toSizeFromSpec(sizeSpec));
    }

    @Override
    public ByteBuffer prepareContent() {
        if (this.buffer == null) {
            assert (this.lowerLimitInclusive == 0 && this.upperLimitExclusive == 1);
            return null;
        }
        int currentLimit = ThreadLocalRandom.current().nextInt(this.lowerLimitInclusive, this.upperLimitExclusive);
        this.buffer.clear();
        this.buffer.limit(currentLimit);
        return this.buffer;
    }
}

