/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common.content;

import java.nio.ByteBuffer;
import net.orpiske.mpt.common.content.ContentStrategy;
import net.orpiske.mpt.common.content.MessageSize;

final class FixedSizeContent
implements ContentStrategy {
    private int size = 0;
    private ByteBuffer buffer = null;

    FixedSizeContent() {
    }

    @Override
    public void setSize(int size) {
        this.size = size;
        this.buffer = ByteBuffer.allocate(size).order(CONTENT_ENDIANNESS);
        for (int i = 0; i < size; ++i) {
            this.buffer.put(i, (byte)i);
        }
    }

    @Override
    public void setSize(String sizeSpec) {
        this.setSize(MessageSize.toSizeFromSpec(sizeSpec));
    }

    @Override
    public ByteBuffer prepareContent() {
        if (this.buffer == null) {
            assert (this.size == 0);
            return this.buffer;
        }
        this.buffer.clear();
        this.buffer.limit(this.size);
        return this.buffer;
    }
}

