/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLQuery {
    private static final Logger logger = LoggerFactory.getLogger(URLQuery.class);
    private List<NameValuePair> params;

    public URLQuery(String uri) throws URISyntaxException {
        this(new URI(uri));
    }

    public URLQuery(URI uri) throws URISyntaxException {
        this.params = URLEncodedUtils.parse((URI)uri, (String)"UTF-8");
        for (NameValuePair param : this.params) {
            logger.trace("{}: {}", (Object)param.getName(), (Object)param.getValue());
        }
    }

    public String getString(String name, String defaultValue) {
        for (NameValuePair param : this.params) {
            if (!param.getName().equals(name)) continue;
            return param.getValue();
        }
        return defaultValue;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        if (value.toLowerCase().equals("true")) {
            return true;
        }
        if (value.toLowerCase().equals("false")) {
            return false;
        }
        return defaultValue;
    }

    public Integer getInteger(String name, Integer defaultValue) {
        String value = this.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public Long getLong(String name, Long defaultValue) {
        String value = this.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }
}

