/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common;

import java.io.File;
import java.util.Properties;
import net.orpiske.mpt.common.Constants;
import org.apache.log4j.PropertyConfigurator;

public class LogConfigurator {
    private LogConfigurator() {
    }

    private static void configureCommon(Properties properties) {
        properties.setProperty("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.stdout.Target", "System.out");
        properties.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
        properties.setProperty("log4j.appender.stdout.layout.ConversionPattern", "%C.%M:%L [%p] %m%n");
        properties.setProperty("log4j.additivity.net.orpiske", "false");
    }

    private static void configureTrace(Properties properties) {
        properties.setProperty("log4j.rootLogger", "DEBUG, stdout");
        properties.setProperty("log4j.logger.net.orpiske", "TRACE, stdout");
    }

    private static void configureDebug(Properties properties) {
        properties.setProperty("log4j.rootLogger", "INFO, stdout");
        properties.setProperty("log4j.logger.net.orpiske", "DEBUG, stdout");
    }

    private static void configureVerbose(Properties properties) {
        properties.setProperty("log4j.rootLogger", "WARN, stdout");
        properties.setProperty("log4j.logger.net.orpiske", "INFO, stdout");
    }

    private static void configureSilent(Properties properties) {
        properties.setProperty("log4j.rootLogger", "WARN, stdout");
        properties.setProperty("log4j.logger.net.orpiske", "WARN, stdout");
    }

    public static void defaultForDaemons() {
        PropertyConfigurator.configure((String)(Constants.MAESTRO_CONFIG_DIR + File.separator + "log4j.properties"));
    }

    public static void trace() {
        Properties properties = new Properties();
        LogConfigurator.configureCommon(properties);
        LogConfigurator.configureTrace(properties);
        PropertyConfigurator.configure((Properties)properties);
    }

    public static void debug() {
        Properties properties = new Properties();
        LogConfigurator.configureCommon(properties);
        LogConfigurator.configureDebug(properties);
        PropertyConfigurator.configure((Properties)properties);
    }

    public static void verbose() {
        Properties properties = new Properties();
        LogConfigurator.configureCommon(properties);
        LogConfigurator.configureVerbose(properties);
        PropertyConfigurator.configure((Properties)properties);
    }

    public static void silent() {
        Properties properties = new Properties();
        LogConfigurator.configureCommon(properties);
        LogConfigurator.configureSilent(properties);
        PropertyConfigurator.configure((Properties)properties);
    }
}

