/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.main;

import java.io.File;
import net.orpiske.mpt.common.LogConfigurator;
import net.orpiske.mpt.common.exceptions.MaestroException;
import net.orpiske.mpt.common.worker.MaestroWorker;
import net.orpiske.mpt.maestro.client.MaestroTopics;
import net.orpiske.mpt.maestro.worker.main.MaestroWorkerExecutor;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Main {
    private static CommandLine cmdLine;
    private static Options options;
    private static String maestroUrl;
    private static String worker;
    private static String role;
    private static String host;
    private static String logDir;

    private static void help(Options options, int code) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("maestro-java", options);
        System.exit(code);
    }

    private static void processCommand(String[] args) {
        PosixParser parser = new PosixParser();
        options = new Options();
        options.addOption("h", "help", false, "prints the help");
        options.addOption("m", "maestro-url", true, "maestro URL to connect to");
        options.addOption("w", "worker", true, "maestro worker to use");
        options.addOption("r", "role", true, "worker role (sender or receiver)");
        options.addOption("H", "host", true, "this' host hostname");
        options.addOption("l", "log-dir", true, "this' host hostname");
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            Main.help(options, -1);
        }
        if (cmdLine.hasOption("help")) {
            Main.help(options, 0);
        }
        if ((maestroUrl = cmdLine.getOptionValue('m')) == null) {
            System.err.println("Maestro URL is missing (option -m)");
            Main.help(options, -1);
        }
        if ((worker = cmdLine.getOptionValue('w')) == null) {
            System.err.println("The worker class is missing (option -w)");
            Main.help(options, -1);
        }
        if ((role = cmdLine.getOptionValue('r')) == null) {
            System.err.println("The worker role is missing (option -w)");
            Main.help(options, -1);
        }
        if ((host = cmdLine.getOptionValue('H')) == null) {
            System.err.println("The peer hostname is missing (option -H)");
            Main.help(options, -1);
        }
        if ((logDir = cmdLine.getOptionValue('l')) == null) {
            System.err.println("The log directory is missing (option -l)");
            Main.help(options, -1);
        }
    }

    public static void main(String[] args) {
        Main.processCommand(args);
        LogConfigurator.defaultForDaemons();
        try {
            Class<MaestroWorker> clazz = Class.forName(worker);
            MaestroWorkerExecutor executor = new MaestroWorkerExecutor(maestroUrl, role, host, new File(logDir), clazz);
            switch (role) {
                case "sender": {
                    executor.start(MaestroTopics.MAESTRO_SENDER_TOPICS);
                    executor.run();
                    break;
                }
                case "receiver": {
                    executor.start(MaestroTopics.MAESTRO_RECEIVER_TOPICS);
                    executor.run();
                    break;
                }
                case "inspector": {
                    executor.start(MaestroTopics.MAESTRO_INSPECTOR_TOPICS);
                    executor.run();
                    break;
                }
                default: {
                    System.err.println("Invalid role name: " + role);
                    System.exit(1);
                }
            }
            System.out.println("Finished execution ...");
        }
        catch (MaestroException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

