/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.base;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.orpiske.mpt.common.client.MaestroReceiver;
import net.orpiske.mpt.common.worker.WorkerStateInfo;
import net.orpiske.mpt.maestro.worker.base.WorkerRuntimeInfo;
import net.orpiske.mpt.maestro.worker.base.WorkerStateInfoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkerWatchdog
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WorkerWatchdog.class);
    private List<WorkerRuntimeInfo> workers;
    private MaestroReceiver endpoint;
    private volatile boolean running = false;
    private final Consumer<? super List<WorkerRuntimeInfo>> onWorkersStopped;

    public WorkerWatchdog(List<WorkerRuntimeInfo> workers, MaestroReceiver endpoint, Consumer<? super List<WorkerRuntimeInfo>> onWorkersStopped) {
        this.workers = new ArrayList<WorkerRuntimeInfo>(workers);
        this.onWorkersStopped = onWorkersStopped;
        this.endpoint = endpoint;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    private boolean workersRunning() {
        int size = this.workers.size();
        for (int i = 0; i < size; ++i) {
            WorkerRuntimeInfo ri = this.workers.get(i);
            if (ri.thread.isAlive()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Running the worker watchdog");
        this.running = true;
        boolean successful = true;
        String exceptionMessage = null;
        try {
            while (this.running && this.workersRunning()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.info("The worker thread was interrupted", e);
                    break;
                }
            }
            for (WorkerRuntimeInfo ri : this.workers) {
                WorkerStateInfo wsi = ri.worker.getWorkerState();
                if (wsi.isRunning() || WorkerStateInfoUtil.isCleanExit(wsi)) continue;
                successful = false;
                exceptionMessage = wsi.getException().getMessage();
                break;
            }
        }
        finally {
            logger.debug("Waiting for flushing workers's data");
            this.onWorkersStopped.accept(this.workers);
            if (successful) {
                this.endpoint.notifySuccess("Test completed successfully");
            } else if (exceptionMessage != null) {
                this.endpoint.notifyFailure(exceptionMessage);
            } else {
                this.endpoint.notifyFailure("Unhandled worker error");
            }
        }
        logger.info("Finished running the worker watchdog");
    }

    public boolean isRunning() {
        return this.running;
    }
}

