/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.base;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerLogUtils {
    private static final Logger logger = LoggerFactory.getLogger(WorkerLogUtils.class);

    public static File findLastLogDir(File logDir) {
        File currentLogDir;
        File lastLogDir = currentLogDir = new File(logDir, "0");
        int count = 0;
        while (currentLogDir.exists()) {
            lastLogDir = currentLogDir;
            currentLogDir = new File(logDir, Integer.toString(++count));
        }
        return lastLogDir;
    }

    public static File findTestLogDir(File logDir) {
        File testLogDir = new File(logDir, "0");
        int count = 0;
        while (testLogDir.exists()) {
            testLogDir = new File(logDir, Integer.toString(++count));
        }
        testLogDir.mkdirs();
        return testLogDir;
    }

    private static void deleteLinkQuietly(File lastLink) {
        logger.debug("Deleting link {} after completing the test", (Object)lastLink.getName());
        try {
            FileUtils.deleteDirectory((File)lastLink);
        }
        catch (IOException e) {
            logger.warn("Unable to delete last link: " + e.getMessage());
        }
    }

    public static void createSymlinks(File logDir, boolean failed) {
        File lastLogDir = WorkerLogUtils.findLastLogDir(logDir);
        Path target = Paths.get(lastLogDir.getAbsolutePath(), new String[0]);
        Path lastLink = Paths.get(lastLogDir.getParent() + File.separator + "last", new String[0]);
        WorkerLogUtils.deleteLinkQuietly(lastLink.toFile());
        try {
            Files.createSymbolicLink(lastLink, target, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.trace("Symbolic link creation error: " + e.getMessage(), e);
        }
        if (failed) {
            Path lastFailedLink = Paths.get(lastLogDir.getParent() + File.separator + "lastFailed", new String[0]);
            WorkerLogUtils.deleteLinkQuietly(lastFailedLink.toFile());
            try {
                Files.createSymbolicLink(lastFailedLink, target, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.trace("Symbolic link creation error: " + e.getMessage(), e);
            }
        } else {
            Path lastSuccessfulLink = Paths.get(lastLogDir.getParent() + File.separator + "lastSuccessful", new String[0]);
            WorkerLogUtils.deleteLinkQuietly(lastSuccessfulLink.toFile());
            try {
                Files.createSymbolicLink(lastSuccessfulLink, target, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.trace("Symbolic link creation error: " + e.getMessage(), e);
            }
        }
    }
}

