/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.base;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.orpiske.mpt.common.worker.MaestroReceiverWorker;
import net.orpiske.mpt.common.worker.MaestroWorker;
import net.orpiske.mpt.common.writers.LatencyWriter;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;

public final class WorkerLatencyWriter
implements Runnable {
    private final List<? extends MaestroWorker> workers;
    private final File reportFolder;
    private final long reportingIntervalMs;
    private final boolean reportIntervalLatencies;

    public WorkerLatencyWriter(File reportFolder, List<? extends MaestroWorker> workers) {
        this.reportFolder = reportFolder;
        this.workers = new ArrayList<MaestroWorker>(workers);
        this.reportingIntervalMs = TimeUnit.DAYS.toMillis(365L);
        this.reportIntervalLatencies = false;
    }

    public WorkerLatencyWriter(File reportFolder, List<? extends MaestroWorker> workers, long reportingIntervalMs) {
        this.reportFolder = reportFolder;
        this.workers = new ArrayList<MaestroWorker>(workers);
        this.reportingIntervalMs = reportingIntervalMs;
        this.reportIntervalLatencies = true;
    }

    private static long getCurrentTimeMsecWithDelay(long nextReportingTime) throws InterruptedException {
        long now = System.currentTimeMillis();
        if (now < nextReportingTime) {
            Thread.sleep(nextReportingTime - now);
        }
        return now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long anyWorkers = this.workers.stream().filter(w -> w instanceof MaestroReceiverWorker).count();
        if (anyWorkers <= 0L) return;
        try (LatencyWriter latencyWriter = new LatencyWriter(new File(this.reportFolder, "receiverd-latency.hdr"));){
            long globalStartReportingTime = System.currentTimeMillis();
            latencyWriter.outputLegend(globalStartReportingTime);
            List<WorkerIntervalReport> workerReports = this.workers.stream().filter(w -> w instanceof MaestroReceiverWorker).map(w -> new WorkerIntervalReport(latencyWriter, (MaestroWorker)w, this.reportIntervalLatencies, globalStartReportingTime)).collect(Collectors.toList());
            Thread currentThread = Thread.currentThread();
            long startTime = System.currentTimeMillis();
            long nextReportingTime = startTime + this.reportingIntervalMs;
            try {
                while (!currentThread.isInterrupted()) {
                    long now = WorkerLatencyWriter.getCurrentTimeMsecWithDelay(nextReportingTime);
                    if (now < nextReportingTime) continue;
                    workerReports.forEach(WorkerIntervalReport::updateReport);
                    workerReports.forEach(WorkerIntervalReport::outputReport);
                    while (now >= nextReportingTime) {
                        nextReportingTime += this.reportingIntervalMs;
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            finally {
                workerReports.forEach(r -> r.updateReport(true));
                workerReports.forEach(WorkerIntervalReport::outputReport);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static final class WorkerIntervalReport {
        private final MaestroWorker worker;
        private final LatencyWriter latencyWriter;
        private long lastReportTime;
        private Histogram intervalHistogram;
        private boolean reportIntervalLatencies;
        private final long startReportingTime;

        public WorkerIntervalReport(LatencyWriter latencyWriter, MaestroWorker worker, boolean reportIntervalLatencies, long globalStartReportingTime) {
            this.latencyWriter = latencyWriter;
            this.worker = worker;
            this.intervalHistogram = null;
            long startedWorkerTime = worker.startedEpochMillis();
            this.startReportingTime = this.lastReportTime = Math.max(globalStartReportingTime, startedWorkerTime < 0L ? System.currentTimeMillis() : startedWorkerTime);
            this.reportIntervalLatencies = reportIntervalLatencies;
        }

        public void updateReport() {
            this.updateReport(false);
        }

        public void updateReport(boolean snapshotLatencies) {
            Histogram intervalHistogram;
            long reportTime = System.currentTimeMillis();
            if ((snapshotLatencies || this.reportIntervalLatencies) && (intervalHistogram = this.worker.takeLatenciesSnapshot(this.intervalHistogram)) != null) {
                if (this.intervalHistogram == null) {
                    intervalHistogram.setStartTimeStamp(this.startReportingTime);
                } else {
                    intervalHistogram.setStartTimeStamp(this.lastReportTime);
                }
                intervalHistogram.setEndTimeStamp(reportTime);
                this.intervalHistogram = intervalHistogram;
            }
            this.lastReportTime = reportTime;
        }

        public void outputReport() {
            if (this.intervalHistogram != null && this.intervalHistogram.getTotalCount() > 0L) {
                this.latencyWriter.outputIntervalHistogram((EncodableHistogram)this.intervalHistogram);
            }
        }
    }
}

