/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.orpiske.mpt.common.client.MaestroReceiver;
import net.orpiske.mpt.common.worker.MaestroWorker;
import net.orpiske.mpt.common.worker.WorkerOptions;
import net.orpiske.mpt.maestro.worker.base.WorkerRuntimeInfo;
import net.orpiske.mpt.maestro.worker.base.WorkerWatchdog;

public final class WorkerContainer {
    private static WorkerContainer instance;
    private WorkerOptions workerOptions;
    private List<WorkerRuntimeInfo> workerRuntimeInfos = new ArrayList<WorkerRuntimeInfo>();
    private WorkerWatchdog workerWatchdog;
    private Thread watchDogThread;
    private MaestroReceiver endpoint;

    private WorkerContainer(MaestroReceiver endpoint) {
        this.endpoint = endpoint;
    }

    public static final synchronized WorkerContainer getInstance(MaestroReceiver endpoint) {
        if (instance == null) {
            instance = new WorkerContainer(endpoint);
        }
        return instance;
    }

    public void setWorkerOptions(WorkerOptions workerOptions) {
        this.workerOptions = workerOptions;
    }

    public void start(Class<MaestroWorker> clazz, Collection<? super MaestroWorker> workers, Consumer<? super List<WorkerRuntimeInfo>> onWorkersStopped) throws IllegalAccessException, InstantiationException {
        int parallelCount = Integer.parseInt(this.workerOptions.getParallelCount());
        this.workerRuntimeInfos.clear();
        try {
            this.createAndStartWorkers(clazz, this.workerOptions, parallelCount, this.workerRuntimeInfos, onWorkersStopped);
        }
        catch (Throwable t) {
            this.workerRuntimeInfos.forEach(info -> info.thread.interrupt());
            this.workerRuntimeInfos.clear();
            throw t;
        }
        workers.addAll(this.workerRuntimeInfos.stream().map(info -> info.worker).collect(Collectors.toList()));
    }

    private void createAndStartWorkers(Class<MaestroWorker> clazz, WorkerOptions workerOptions, int workers, List<WorkerRuntimeInfo> workerRuntimeInfos, Consumer<? super List<WorkerRuntimeInfo>> onWorkersStopped) throws IllegalAccessException, InstantiationException {
        for (int i = 0; i < workers; ++i) {
            WorkerRuntimeInfo ri = new WorkerRuntimeInfo();
            ri.worker = clazz.newInstance();
            ri.worker.setWorkerOptions(workerOptions);
            ri.worker.setWorkerNumber(i);
            ri.thread = new Thread((Runnable)ri.worker);
            ri.thread.start();
            workerRuntimeInfos.add(ri);
        }
        this.workerWatchdog = new WorkerWatchdog(workerRuntimeInfos, this.endpoint, onWorkersStopped);
        this.watchDogThread = new Thread(this.workerWatchdog);
        this.watchDogThread.start();
    }

    public void stop() {
        for (WorkerRuntimeInfo ri : this.workerRuntimeInfos) {
            ri.worker.stop();
        }
        if (this.workerWatchdog != null) {
            this.workerWatchdog.setRunning(false);
        }
    }

    public boolean isTestInProgress() {
        if (this.watchDogThread == null) {
            return false;
        }
        if (this.workerWatchdog.isRunning()) {
            for (WorkerRuntimeInfo ri : this.workerRuntimeInfos) {
                if (ri.worker.isRunning()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

