/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.base;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.orpiske.mpt.common.worker.MaestroReceiverWorker;
import net.orpiske.mpt.common.worker.MaestroSenderWorker;
import net.orpiske.mpt.common.worker.MaestroWorker;
import net.orpiske.mpt.common.writers.OneToOneWorkerChannel;
import net.orpiske.mpt.common.writers.RateWriter;
import org.agrona.concurrent.SleepingIdleStrategy;

public final class WorkerChannelWriter
implements Runnable {
    private final List<? extends MaestroWorker> workers;
    private final File reportFolder;
    private final boolean compressed;

    public WorkerChannelWriter(File reportFolder, List<? extends MaestroWorker> workers) {
        this.reportFolder = reportFolder;
        this.workers = new ArrayList<MaestroWorker>(workers);
        this.compressed = true;
    }

    private RateWriter createRateWriter(boolean sender) throws IOException {
        return new RateWriter(this.reportFolder, sender, this.compressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int drainLimit = 128;
        RateWriter senderRateWriter = null;
        RateWriter receiverRateWriter = null;
        try {
            int workersCount = this.workers.size();
            ArrayList<WorkerRateReport> rateReports = new ArrayList<WorkerRateReport>(workersCount);
            for (int workerId = 0; workerId < workersCount; ++workerId) {
                MaestroWorker worker = this.workers.get(workerId);
                if (worker.workerChannel() == null) continue;
                boolean sender = worker instanceof MaestroSenderWorker;
                boolean receiver = worker instanceof MaestroReceiverWorker;
                assert (!sender || !receiver);
                RateWriter rateWriter = null;
                if (sender) {
                    rateWriter = senderRateWriter = senderRateWriter == null ? this.createRateWriter(true) : senderRateWriter;
                } else if (receiver) {
                    rateWriter = receiverRateWriter = receiverRateWriter == null ? this.createRateWriter(false) : receiverRateWriter;
                }
                if (rateWriter == null) continue;
                rateReports.add(new WorkerRateReport(worker, rateWriter));
            }
            int rateReportsCount = rateReports.size();
            if (rateReportsCount > 0) {
                WorkerRateReport report;
                Thread currentThread = Thread.currentThread();
                SleepingIdleStrategy idleStrategy = new SleepingIdleStrategy(1000L);
                while (!currentThread.isInterrupted()) {
                    int events = 0;
                    for (int i = 0; i < rateReportsCount; ++i) {
                        report = (WorkerRateReport)rateReports.get(i);
                        events += report.updateReport(128);
                    }
                    idleStrategy.idle(events);
                }
                boolean allDrained = false;
                while (!allDrained) {
                    allDrained = true;
                    for (int i = 0; i < rateReportsCount; ++i) {
                        report = (WorkerRateReport)rateReports.get(i);
                        if (report.updateReport(128) <= 0) continue;
                        allDrained = false;
                    }
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (senderRateWriter != null) {
                    senderRateWriter.close();
                }
            }
            finally {
                try {
                    if (receiverRateWriter != null) {
                        receiverRateWriter.close();
                    }
                }
                finally {
                    long totalMissed = this.workers.stream().filter(w -> w.workerChannel() != null).map(MaestroWorker::workerChannel).mapToLong(OneToOneWorkerChannel::missedSamples).sum();
                    if (totalMissed > 0L) {
                        System.err.println("TOTAL MISSED RATE SAMPLES= " + totalMissed);
                    }
                }
            }
        }
    }

    private static final class WorkerRateReport {
        private final RateWriter rateWriter;
        private final MaestroWorker worker;
        private final Consumer<OneToOneWorkerChannel.Sample> onRate;

        public WorkerRateReport(MaestroWorker worker, RateWriter rateWriter) {
            this.rateWriter = rateWriter;
            this.worker = worker;
            this.onRate = this::onRate;
        }

        private void onRate(OneToOneWorkerChannel.Sample rate) {
            this.rateWriter.write(rate.timestampEpochMicros(), rate.value());
        }

        public int updateReport(int drainLimit) {
            return this.worker.workerChannel().readRate(this.onRate, drainLimit);
        }
    }
}

