/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.base;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.orpiske.mpt.common.URLQuery;
import net.orpiske.mpt.common.client.MaestroReceiver;
import net.orpiske.mpt.common.exceptions.DurationParseException;
import net.orpiske.mpt.common.exceptions.MaestroConnectionException;
import net.orpiske.mpt.common.exceptions.MaestroException;
import net.orpiske.mpt.common.test.TestProperties;
import net.orpiske.mpt.common.worker.MaestroInspectorWorker;
import net.orpiske.mpt.common.worker.MaestroReceiverWorker;
import net.orpiske.mpt.common.worker.MaestroSenderWorker;
import net.orpiske.mpt.common.worker.MaestroWorker;
import net.orpiske.mpt.common.worker.WorkerOptions;
import net.orpiske.mpt.common.worker.WorkerStateInfo;
import net.orpiske.mpt.maestro.MaestroReceiverClient;
import net.orpiske.mpt.maestro.client.AbstractMaestroPeer;
import net.orpiske.mpt.maestro.client.MaestroDeserializer;
import net.orpiske.mpt.maestro.exceptions.MalformedNoteException;
import net.orpiske.mpt.maestro.notes.AbnormalDisconnect;
import net.orpiske.mpt.maestro.notes.FlushRequest;
import net.orpiske.mpt.maestro.notes.Halt;
import net.orpiske.mpt.maestro.notes.MaestroEvent;
import net.orpiske.mpt.maestro.notes.MaestroEventListener;
import net.orpiske.mpt.maestro.notes.PingRequest;
import net.orpiske.mpt.maestro.notes.SetRequest;
import net.orpiske.mpt.maestro.notes.StartInspector;
import net.orpiske.mpt.maestro.notes.StartReceiver;
import net.orpiske.mpt.maestro.notes.StartSender;
import net.orpiske.mpt.maestro.notes.StatsRequest;
import net.orpiske.mpt.maestro.notes.StopInspector;
import net.orpiske.mpt.maestro.notes.StopReceiver;
import net.orpiske.mpt.maestro.notes.StopSender;
import net.orpiske.mpt.maestro.notes.TestFailedNotification;
import net.orpiske.mpt.maestro.notes.TestSuccessfulNotification;
import net.orpiske.mpt.maestro.worker.base.WorkerChannelWriter;
import net.orpiske.mpt.maestro.worker.base.WorkerContainer;
import net.orpiske.mpt.maestro.worker.base.WorkerLatencyWriter;
import net.orpiske.mpt.maestro.worker.base.WorkerLogUtils;
import net.orpiske.mpt.maestro.worker.base.WorkerRuntimeInfo;
import net.orpiske.mpt.maestro.worker.base.WorkerStateInfoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaestroWorkerManager
extends AbstractMaestroPeer<MaestroEvent>
implements MaestroEventListener {
    private static final long TIMEOUT_STOP_WORKER_MILLIS = 1000L;
    private static final Logger logger = LoggerFactory.getLogger(MaestroWorkerManager.class);
    private MaestroReceiverClient client;
    private WorkerContainer container;
    private String host;
    private Class<MaestroWorker> workerClass;
    private File logDir;
    private WorkerOptions workerOptions;
    private Thread latencyWriterThread;
    private Thread rateWriterThread;
    private boolean running = true;

    public MaestroWorkerManager(String maestroURL, String role, String host, File logDir, Class<MaestroWorker> workerClass) throws MaestroException {
        super(maestroURL, role, MaestroDeserializer::deserializeEvent);
        this.client = new MaestroReceiverClient(maestroURL, this.clientName, host, this.id);
        this.workerClass = workerClass;
        this.host = host;
        this.logDir = logDir;
        this.container = WorkerContainer.getInstance((MaestroReceiver)this.client);
        this.workerOptions = new WorkerOptions();
    }

    public void connect() throws MaestroConnectionException {
        super.connect();
        this.client.connect();
    }

    public boolean isRunning() {
        return this.running;
    }

    protected final void noteArrived(MaestroEvent note) throws IOException, MaestroConnectionException {
        logger.debug("Some message arrived: {}", (Object)note.toString());
        note.notify((MaestroEventListener)this);
    }

    public void handle(StatsRequest note) {
        logger.debug("Stats request received");
    }

    public void handle(FlushRequest note) {
        logger.debug("Flush request received");
    }

    public void handle(Halt note) {
        logger.debug("Halt request received");
        this.container.stop();
        this.running = false;
    }

    public void handle(SetRequest note) {
        logger.debug("Set request received");
        switch (note.getOption()) {
            case MAESTRO_NOTE_OPT_SET_BROKER: {
                this.workerOptions.setBrokerURL(note.getValue());
                break;
            }
            case MAESTRO_NOTE_OPT_SET_DURATION_TYPE: {
                this.workerOptions.setDuration(note.getValue());
                break;
            }
            case MAESTRO_NOTE_OPT_SET_LOG_LEVEL: {
                this.workerOptions.setLogLevel(note.getValue());
                break;
            }
            case MAESTRO_NOTE_OPT_SET_PARALLEL_COUNT: {
                this.workerOptions.setParallelCount(note.getValue());
                break;
            }
            case MAESTRO_NOTE_OPT_SET_MESSAGE_SIZE: {
                this.workerOptions.setMessageSize(note.getValue());
                break;
            }
            case MAESTRO_NOTE_OPT_SET_THROTTLE: {
                this.workerOptions.setThrottle(note.getValue());
                break;
            }
            case MAESTRO_NOTE_OPT_SET_RATE: {
                this.workerOptions.setRate(note.getValue());
                break;
            }
            case MAESTRO_NOTE_OPT_FCL: {
                this.workerOptions.setFcl(note.getValue());
            }
        }
        this.container.setWorkerOptions(this.workerOptions);
        this.client.replyOk();
    }

    private void writeTestProperties(File testLogDir) throws IOException, URISyntaxException, DurationParseException {
        TestProperties testProperties = new TestProperties();
        testProperties.setBrokerUri(this.workerOptions.getBrokerURL());
        testProperties.setDuration(this.workerOptions.getDuration());
        testProperties.setParallelCount(this.workerOptions.getParallelCount());
        testProperties.setMessageSize(this.workerOptions.getMessageSize());
        testProperties.setRate(this.workerOptions.getRate());
        testProperties.setFcl(this.workerOptions.getFcl());
        URLQuery urlQuery = new URLQuery(this.workerOptions.getBrokerURL());
        testProperties.setProtocol(urlQuery.getString("protocol", "AMQP"));
        testProperties.setApiName("JMS");
        testProperties.setApiVersion("1.1");
        testProperties.write(new File(testLogDir, "test.properties"));
    }

    private boolean doWorkerStart() {
        if (this.container.isTestInProgress()) {
            logger.warn("Trying to start a new test, but a test execution is already in progress");
            this.client.notifyFailure("Test already in progress");
            return false;
        }
        File testLogDir = WorkerLogUtils.findTestLogDir(this.logDir);
        try {
            this.writeTestProperties(testLogDir);
            ArrayList workers = new ArrayList();
            logger.debug("Starting the workers {}", (Object)this.workerClass);
            this.container.start(this.workerClass, workers, this::onStoppedWorkers);
            if (workers.isEmpty()) {
                logger.warn("No workers has been started!");
            } else {
                Thread rateThread;
                Thread latencyThread;
                logger.debug("Creating the writer threads");
                WorkerLatencyWriter latencyWriter = new WorkerLatencyWriter(testLogDir, workers);
                this.latencyWriterThread = latencyThread = new Thread(latencyWriter);
                WorkerChannelWriter rateWriter = new WorkerChannelWriter(testLogDir, workers);
                this.rateWriterThread = rateThread = new Thread(rateWriter);
                logger.debug("Starting the writers threads");
                this.latencyWriterThread.start();
                this.rateWriterThread.start();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdownAndWaitWriters()));
            }
            this.client.replyOk();
            return true;
        }
        catch (Exception e) {
            logger.error("Unable to start workers from the container: {}", (Object)e.getMessage(), (Object)e);
            this.client.replyInternalError();
            return false;
        }
    }

    private void shutdownAndWaitWriters() {
        if (this.rateWriterThread != null) {
            this.rateWriterThread.interrupt();
        }
        if (this.latencyWriterThread != null) {
            this.latencyWriterThread.interrupt();
        }
        if (this.rateWriterThread != null) {
            try {
                this.rateWriterThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.latencyWriterThread != null) {
            try {
                this.latencyWriterThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean awaitWorkers(long startWaitingWorkersEpochMillis, List<WorkerRuntimeInfo> workers) {
        long deadLine = startWaitingWorkersEpochMillis + (long)workers.size() * 1000L * 2L;
        boolean allFinished = false;
        block4: while (!allFinished && System.currentTimeMillis() < deadLine) {
            allFinished = true;
            int size = workers.size();
            for (int i = 0; i < size; ++i) {
                WorkerRuntimeInfo workerRuntimeInfo = workers.get(i);
                try {
                    workerRuntimeInfo.thread.join(1000L);
                    boolean bl = allFinished = !workerRuntimeInfo.thread.isAlive();
                }
                catch (InterruptedException interruptedException) {
                    boolean bl = allFinished = !workerRuntimeInfo.thread.isAlive();
                    if (allFinished) continue;
                    continue block4;
                    catch (Throwable throwable) {
                        boolean bl2 = allFinished = !workerRuntimeInfo.thread.isAlive();
                        if (!allFinished) continue block4;
                        throw throwable;
                    }
                }
                if (allFinished) continue;
                continue block4;
            }
        }
        return allFinished;
    }

    private void onStoppedWorkers(List<WorkerRuntimeInfo> workers) {
        if (this.rateWriterThread != null || this.latencyWriterThread != null) {
            boolean allFinished;
            long startWaitingWorkers = System.currentTimeMillis();
            if (!workers.isEmpty() && !(allFinished = MaestroWorkerManager.awaitWorkers(startWaitingWorkers, workers))) {
                logger.warn("The writer will be forced to stop with alive workers");
            }
            this.shutdownAndWaitWriters();
            long elapsedMillis = System.currentTimeMillis() - startWaitingWorkers;
            logger.info("Awaiting workers and shutting down writers took {} ms", (Object)elapsedMillis);
        }
        boolean failed = false;
        for (WorkerRuntimeInfo ri : workers) {
            WorkerStateInfo wsi = ri.worker.getWorkerState();
            if (WorkerStateInfoUtil.isCleanExit(wsi)) continue;
            failed = true;
            break;
        }
        WorkerLogUtils.createSymlinks(this.logDir, failed);
    }

    public void handle(StartInspector note) {
        logger.debug("Start inspector request received");
        if (MaestroInspectorWorker.class.isAssignableFrom(this.workerClass) && !this.doWorkerStart()) {
            logger.warn("::handle {} can't start worker", (Object)note);
        }
    }

    public void handle(StartReceiver note) {
        logger.debug("Start receiver request received");
        if (MaestroReceiverWorker.class.isAssignableFrom(this.workerClass) && !this.doWorkerStart()) {
            logger.warn("::handle {} can't start worker", (Object)note);
        }
    }

    public void handle(StartSender note) {
        logger.debug("Start sender request received");
        if (MaestroSenderWorker.class.isAssignableFrom(this.workerClass) && !this.doWorkerStart()) {
            logger.warn("::handle {} can't start worker", (Object)note);
        }
    }

    public void handle(StopInspector note) {
        logger.debug("Stop inspector request received");
        if (MaestroInspectorWorker.class.isAssignableFrom(this.workerClass)) {
            this.container.stop();
        }
        this.client.replyOk();
    }

    public void handle(StopReceiver note) {
        logger.debug("Stop receiver request received");
        if (MaestroReceiverWorker.class.isAssignableFrom(this.workerClass)) {
            this.container.stop();
        }
        this.client.replyOk();
    }

    public void handle(StopSender note) {
        logger.debug("Stop sender request received");
        if (MaestroSenderWorker.class.isAssignableFrom(this.workerClass)) {
            this.container.stop();
        }
        this.client.replyOk();
    }

    public void handle(TestFailedNotification note) {
        logger.info("Test failed notification received from {}: {}", (Object)note.getName(), (Object)note.getMessage());
        this.container.stop();
    }

    public void handle(TestSuccessfulNotification note) {
        logger.info("Test successful notification received from {}: {}", (Object)note.getName(), (Object)note.getMessage());
    }

    public void handle(AbnormalDisconnect note) {
        logger.info("Abnormal disconnect notification received from {}: {}", (Object)note.getName(), (Object)note.getMessage());
    }

    public void handle(PingRequest note) throws MaestroConnectionException, MalformedNoteException {
        this.client.pingResponse(note.getSec(), note.getUsec());
    }
}

