/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.jms;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import net.orpiske.mpt.common.content.ContentStrategy;
import net.orpiske.mpt.common.content.ContentStrategyFactory;
import net.orpiske.mpt.common.duration.EpochClocks;
import net.orpiske.mpt.common.duration.EpochMicroClock;
import net.orpiske.mpt.common.duration.TestDuration;
import net.orpiske.mpt.common.duration.TestDurationBuilder;
import net.orpiske.mpt.common.exceptions.DurationParseException;
import net.orpiske.mpt.common.jms.SenderClient;
import net.orpiske.mpt.common.worker.MaestroSenderWorker;
import net.orpiske.mpt.common.worker.WorkerOptions;
import net.orpiske.mpt.common.worker.WorkerStateInfo;
import net.orpiske.mpt.common.writers.OneToOneWorkerChannel;
import net.orpiske.mpt.maestro.worker.jms.JMSSenderClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSSenderWorker
implements MaestroSenderWorker {
    private static final Logger logger = LoggerFactory.getLogger(JMSSenderWorker.class);
    private ContentStrategy contentStrategy;
    private TestDuration duration;
    private final OneToOneWorkerChannel workerChannel;
    private final AtomicLong messageCount = new AtomicLong(0L);
    private volatile long startedEpochMillis = Long.MIN_VALUE;
    private String url;
    private long rate = 0L;
    private int number;
    private final Supplier<? extends SenderClient> clientFactory;
    private volatile WorkerStateInfo workerStateInfo = new WorkerStateInfo();

    public JMSSenderWorker() {
        this(JMSSenderClient::new, 131072);
    }

    public JMSSenderWorker(Supplier<? extends SenderClient> clientFactory, int channelCapacity) {
        this.clientFactory = clientFactory;
        this.workerChannel = new OneToOneWorkerChannel(channelCapacity);
    }

    public OneToOneWorkerChannel workerChannel() {
        return this.workerChannel;
    }

    public long startedEpochMillis() {
        return this.startedEpochMillis;
    }

    public WorkerStateInfo getWorkerState() {
        return this.workerStateInfo;
    }

    public long messageCount() {
        return this.messageCount.get();
    }

    private void setMessageSize(String messageSize) {
        this.contentStrategy = ContentStrategyFactory.parse((String)messageSize);
    }

    private void setRate(String rate) {
        this.rate = Long.parseLong(rate);
    }

    private void setBroker(String url) {
        this.url = url;
    }

    private void setDuration(String duration) {
        try {
            this.duration = TestDurationBuilder.build((String)duration);
        }
        catch (DurationParseException e) {
            e.printStackTrace();
        }
    }

    public void setWorkerNumber(int number) {
        this.number = number;
    }

    public void setWorkerOptions(WorkerOptions workerOptions) {
        this.setRate(workerOptions.getRate());
        this.setDuration(workerOptions.getDuration());
        this.setBroker(workerOptions.getBrokerURL());
        this.setMessageSize(workerOptions.getMessageSize());
    }

    private static long waitNanoInterval(long expectedFireTime, long intervalInNanos) {
        long now;
        assert (intervalInNanos > 0L);
        do {
            if ((now = System.nanoTime()) - expectedFireTime >= 0L) continue;
            LockSupport.parkNanos(expectedFireTime - now);
        } while (now - expectedFireTime < 0L);
        return now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.startedEpochMillis = System.currentTimeMillis();
        logger.info("Starting the test");
        SenderClient client = this.clientFactory.get();
        try {
            long intervalInNanos;
            EpochMicroClock epochMicroClock = EpochClocks.exclusiveMicro();
            client.setUrl(this.url);
            client.setContentStrategy(this.contentStrategy);
            this.workerStateInfo.setState(true, null, null);
            client.setNumber(this.number);
            client.start();
            long count = 0L;
            long l = intervalInNanos = this.rate > 0L ? 1000000000L / this.rate : 0L;
            if (intervalInNanos > 0L) {
                logger.info("JMS Sender Worker {} has started firing events with an interval of {} ns and rate of " + this.rate + " msg/sec", (Object)Thread.currentThread().getId(), (Object)intervalInNanos);
            }
            long startFireEpochMicros = epochMicroClock.microTime();
            long elapsedIntervalsNanos = 0L;
            long nextFireTime = System.nanoTime() + intervalInNanos;
            while (this.duration.canContinue((TestDuration.TestProgress)this) && this.isRunning()) {
                long expectedSendTimeEpochMicros;
                if (intervalInNanos > 0L) {
                    long now = JMSSenderWorker.waitNanoInterval(nextFireTime, intervalInNanos);
                    assert (now - nextFireTime >= 0L) : "can't wait less than the configured interval in nanos";
                    nextFireTime += intervalInNanos;
                    elapsedIntervalsNanos += intervalInNanos;
                }
                long sendTimeEpochMicros = epochMicroClock.microTime();
                if (intervalInNanos > 0L) {
                    long elapsedIntervalsMicros = elapsedIntervalsNanos / 1000L;
                    expectedSendTimeEpochMicros = startFireEpochMicros + elapsedIntervalsMicros;
                } else {
                    expectedSendTimeEpochMicros = sendTimeEpochMicros;
                }
                client.sendMessages(sendTimeEpochMicros);
                this.workerChannel.emitRate(expectedSendTimeEpochMicros, sendTimeEpochMicros);
                this.messageCount.lazySet(++count);
            }
            logger.info("Test completed successfully");
            this.workerStateInfo.setState(false, WorkerStateInfo.WorkerExitStatus.WORKER_EXIT_SUCCESS, null);
        }
        catch (InterruptedException e) {
            logger.error("JMS Sender Worker {} interrupted while sending messages: {}", (Object)Thread.currentThread().getId(), (Object)e.getMessage());
            this.workerStateInfo.setState(false, WorkerStateInfo.WorkerExitStatus.WORKER_EXIT_FAILURE, (Exception)e);
        }
        catch (Exception e) {
            logger.error("Unable to start the sender worker: {}", (Object)e.getMessage(), (Object)e);
            this.workerStateInfo.setState(false, WorkerStateInfo.WorkerExitStatus.WORKER_EXIT_FAILURE, e);
        }
        finally {
            client.stop();
        }
    }

    public boolean isRunning() {
        return this.workerStateInfo.isRunning();
    }

    public void stop() {
        this.workerStateInfo.setState(false, WorkerStateInfo.WorkerExitStatus.WORKER_EXIT_STOPPED, null);
    }

    public void halt() {
        this.stop();
    }

    public void run() {
        this.start();
    }
}

