/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.jms;

import java.net.URI;
import java.nio.ByteBuffer;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import net.orpiske.mpt.common.URLQuery;
import net.orpiske.mpt.common.content.ContentStrategy;
import net.orpiske.mpt.common.jms.SenderClient;
import net.orpiske.mpt.maestro.worker.jms.JMSClient;
import net.orpiske.mpt.maestro.worker.jms.JMSResourceUtil;

final class JMSSenderClient
extends JMSClient
implements SenderClient {
    private ContentStrategy contentStrategy;
    private Session session;
    private MessageProducer producer;

    JMSSenderClient() {
    }

    @Override
    public void start() throws Exception {
        super.start();
        try {
            Long ttl;
            this.session = this.connection.createSession(false, 1);
            this.producer = this.session.createProducer(this.destination);
            URLQuery urlQuery = new URLQuery(new URI(this.url));
            boolean durable = urlQuery.getBoolean("durable", false);
            if (durable) {
                this.producer.setDeliveryMode(2);
            } else {
                this.producer.setDeliveryMode(1);
            }
            Integer priority = urlQuery.getInteger("priority", null);
            if (priority != null) {
                this.producer.setPriority(priority.intValue());
            }
            if ((ttl = urlQuery.getLong("ttl", null)) != null) {
                this.producer.setTimeToLive(ttl.longValue());
            }
            this.producer.setDisableMessageTimestamp(true);
        }
        catch (Throwable t) {
            JMSResourceUtil.capturingClose(this.producer);
            this.producer = null;
            JMSResourceUtil.capturingClose(this.session);
            this.session = null;
            JMSResourceUtil.capturingClose(this.connection);
            this.connection = null;
            throw t;
        }
    }

    public void sendMessages(long sendTimeEpochInMicros) throws JMSException {
        ByteBuffer content = this.contentStrategy.prepareContent();
        byte[] bytes = content.array();
        int position = content.position();
        int offset = content.arrayOffset() + position;
        int length = content.remaining();
        content.putLong(position, sendTimeEpochInMicros);
        BytesMessage message = this.session.createBytesMessage();
        message.writeBytes(bytes, offset, length);
        this.producer.send((Message)message);
    }

    public void setContentStrategy(ContentStrategy contentStrategy) {
        this.contentStrategy = contentStrategy;
    }

    @Override
    public void stop() {
        JMSResourceUtil.capturingClose(this.producer);
        this.producer = null;
        JMSResourceUtil.capturingClose(this.session);
        this.session = null;
        super.stop();
    }
}

