/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.jms;

import javax.jms.Connection;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JMSResourceUtil {
    private static final Logger logger = LoggerFactory.getLogger(JMSResourceUtil.class);

    private JMSResourceUtil() {
    }

    public static Throwable capturingClose(MessageProducer closeable) {
        logger.debug("Closing the producer ");
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                return t;
            }
        }
        return null;
    }

    public static Throwable capturingClose(Session closeable) {
        logger.debug("Closing the session ");
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                return t;
            }
        }
        return null;
    }

    public static Throwable capturingClose(MessageConsumer closeable) {
        logger.debug("Closing the consumer");
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                return t;
            }
        }
        return null;
    }

    public static Throwable capturingClose(Connection closeable) {
        logger.debug("Closing the connection");
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                return t;
            }
        }
        return null;
    }
}

