/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.jms;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.orpiske.mpt.common.duration.EpochClocks;
import net.orpiske.mpt.common.duration.EpochMicroClock;
import net.orpiske.mpt.common.duration.TestDuration;
import net.orpiske.mpt.common.duration.TestDurationBuilder;
import net.orpiske.mpt.common.exceptions.DurationParseException;
import net.orpiske.mpt.common.jms.ReceiverClient;
import net.orpiske.mpt.common.worker.MaestroReceiverWorker;
import net.orpiske.mpt.common.worker.WorkerOptions;
import net.orpiske.mpt.common.worker.WorkerStateInfo;
import net.orpiske.mpt.common.writers.OneToOneWorkerChannel;
import net.orpiske.mpt.maestro.worker.jms.JMSReceiverClient;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.SingleWriterRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSReceiverWorker
implements MaestroReceiverWorker {
    private static final Logger logger = LoggerFactory.getLogger(JMSReceiverWorker.class);
    private TestDuration duration;
    private final AtomicLong messageCount = new AtomicLong(0L);
    private volatile long startedEpochMillis = Long.MIN_VALUE;
    private static final long HIGHEST_TRACKABLE_VALUE = TimeUnit.HOURS.toMicros(1L);
    private final SingleWriterRecorder latencyRecorder = new SingleWriterRecorder(HIGHEST_TRACKABLE_VALUE, 3);
    private final OneToOneWorkerChannel workerChannel = new OneToOneWorkerChannel(131072);
    private volatile WorkerStateInfo workerStateInfo = new WorkerStateInfo();
    private String url;
    private final Supplier<? extends ReceiverClient> clientFactory;
    private int number;

    public OneToOneWorkerChannel workerChannel() {
        return this.workerChannel;
    }

    public long messageCount() {
        return this.messageCount.get();
    }

    public WorkerStateInfo getWorkerState() {
        return this.workerStateInfo;
    }

    public long startedEpochMillis() {
        return this.startedEpochMillis;
    }

    private void setFCL(String fcl) {
    }

    private void setBroker(String url) {
        this.url = url;
    }

    private void setDuration(String duration) {
        try {
            this.duration = TestDurationBuilder.build((String)duration);
        }
        catch (DurationParseException e) {
            e.printStackTrace();
        }
    }

    public JMSReceiverWorker() {
        this(JMSReceiverClient::new);
    }

    public JMSReceiverWorker(Supplier<? extends ReceiverClient> clientFactory) {
        this.clientFactory = clientFactory;
    }

    public void setWorkerNumber(int number) {
        this.number = number;
    }

    public void setWorkerOptions(WorkerOptions workerOptions) {
        this.setBroker(workerOptions.getBrokerURL());
        this.setDuration(workerOptions.getDuration());
    }

    private static void handleNegativeSampleError(long sendTimeEpochMicros, long nowInMicros) {
        logger.error("Dropped sample: SendTimeEpochMicros {} > ReceivedTimeEpochMicros {}", (Object)sendTimeEpochMicros, (Object)nowInMicros);
    }

    private static void handleHugeSampleError(long sendTimeEpochMicros, long nowInMicros) {
        logger.error("Normalized sample: (ReceivedTimeEpochMicros {} - SendTimeEpochMicros {}) > " + HIGHEST_TRACKABLE_VALUE, (Object)nowInMicros, (Object)sendTimeEpochMicros);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.startedEpochMillis = System.currentTimeMillis();
        logger.info("Starting the test");
        ReceiverClient client = this.clientFactory.get();
        try {
            EpochMicroClock epochMicroClock = EpochClocks.exclusiveMicro();
            client.setUrl(this.url);
            this.workerStateInfo.setState(true, null, null);
            client.setNumber(this.number);
            client.start();
            long count = 0L;
            while (this.duration.canContinue((TestDuration.TestProgress)this) && this.isRunning()) {
                long sendTimeEpochMicros = client.receiveMessages();
                if (sendTimeEpochMicros == ReceiverClient.noMessagePayload()) continue;
                long nowInMicros = epochMicroClock.microTime();
                long elapsedMicros = nowInMicros - sendTimeEpochMicros;
                boolean validLatency = true;
                if (elapsedMicros < 0L) {
                    JMSReceiverWorker.handleNegativeSampleError(sendTimeEpochMicros, nowInMicros);
                    validLatency = false;
                } else if (elapsedMicros == 0L) {
                    logger.warn("Registered Latency of 0: please consider to improve timestamp precision");
                } else if (elapsedMicros > HIGHEST_TRACKABLE_VALUE) {
                    JMSReceiverWorker.handleHugeSampleError(sendTimeEpochMicros, nowInMicros);
                    elapsedMicros = HIGHEST_TRACKABLE_VALUE;
                }
                if (validLatency) {
                    this.latencyRecorder.recordValue(elapsedMicros);
                }
                this.workerChannel.emitRate(sendTimeEpochMicros, nowInMicros);
                this.messageCount.lazySet(++count);
            }
            logger.info("Test completed successfully");
            this.workerStateInfo.setState(false, WorkerStateInfo.WorkerExitStatus.WORKER_EXIT_SUCCESS, null);
        }
        catch (Exception e) {
            logger.error("Unable to start the receiver worker: {}", (Object)e.getMessage(), (Object)e);
            this.workerStateInfo.setState(false, WorkerStateInfo.WorkerExitStatus.WORKER_EXIT_FAILURE, e);
        }
        finally {
            client.stop();
        }
    }

    public Histogram takeLatenciesSnapshot(Histogram intervalHistogram) {
        return this.latencyRecorder.getIntervalHistogram(intervalHistogram);
    }

    public boolean isRunning() {
        return this.workerStateInfo.isRunning();
    }

    public void stop() {
        this.workerStateInfo.setState(false, WorkerStateInfo.WorkerExitStatus.WORKER_EXIT_STOPPED, null);
    }

    public void halt() {
        this.stop();
    }

    public void run() {
        this.start();
    }
}

