/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.jms;

import java.nio.ByteBuffer;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import net.orpiske.mpt.common.content.ContentStrategy;
import net.orpiske.mpt.common.jms.ReceiverClient;
import net.orpiske.mpt.maestro.worker.jms.JMSClient;
import net.orpiske.mpt.maestro.worker.jms.JMSResourceUtil;

final class JMSReceiverClient
extends JMSClient
implements ReceiverClient {
    private static final long RECEIVE_TIMEOUT_MILLIS = 1000L;
    private static final int PAYLOAD_SIZE = 8;
    private Session session;
    private MessageConsumer consumer;
    private ByteBuffer payloadBytes;

    JMSReceiverClient() {
    }

    @Override
    public void start() throws Exception {
        super.start();
        try {
            this.session = this.connection.createSession(false, 1);
            this.consumer = this.session.createConsumer(this.destination);
            this.payloadBytes = ByteBuffer.allocate(8).order(ContentStrategy.CONTENT_ENDIANNESS);
        }
        catch (Throwable t) {
            JMSResourceUtil.capturingClose(this.consumer);
            this.consumer = null;
            JMSResourceUtil.capturingClose(this.session);
            this.session = null;
            JMSResourceUtil.capturingClose(this.connection);
            this.connection = null;
        }
    }

    public long receiveMessages() throws Exception {
        Message message = this.consumer.receive(1000L);
        if (message == null) {
            return ReceiverClient.noMessagePayload();
        }
        BytesMessage bytesMessage = (BytesMessage)message;
        int readBytes = bytesMessage.readBytes(this.payloadBytes.array(), 8);
        if (readBytes == 8 || readBytes == -1) {
            long sendTime = this.payloadBytes.getLong(0);
            return sendTime;
        }
        throw new IllegalStateException("the received message hasn't any benchmark payload");
    }

    @Override
    public void stop() {
        JMSResourceUtil.capturingClose(this.consumer);
        this.consumer = null;
        JMSResourceUtil.capturingClose(this.session);
        this.session = null;
        super.stop();
    }
}

