/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.jms;

import java.util.function.Function;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.JmsQueue;
import org.apache.qpid.jms.JmsTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JMSProtocol {
    ARTEMIS(org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory::new, org.apache.activemq.artemis.jms.client.ActiveMQQueue::new, ActiveMQTopic::new),
    AMQP(JmsConnectionFactory::new, JmsQueue::new, JmsTopic::new),
    OPENWIRE(ActiveMQConnectionFactory::new, ActiveMQQueue::new, org.apache.activemq.command.ActiveMQTopic::new);

    private static final Logger logger;
    private final Function<String, ? extends ConnectionFactory> factory;
    private final Function<String, ? extends Queue> queueFactory;
    private final Function<String, ? extends Topic> topicFactory;

    private JMSProtocol(Function<String, ? extends ConnectionFactory> factory, Function<String, ? extends Queue> queueFactory, Function<String, ? extends Topic> topicFactory) {
        this.factory = factory;
        this.queueFactory = queueFactory;
        this.topicFactory = topicFactory;
    }

    ConnectionFactory createConnectionFactory(String uri) {
        logger.debug("Creating an {} connection to {}", (Object)this.name(), (Object)uri);
        return this.factory.apply(uri);
    }

    Queue createQueue(String name) {
        return this.queueFactory.apply(name);
    }

    Topic createTopic(String name) {
        return this.topicFactory.apply(name);
    }

    static {
        logger = LoggerFactory.getLogger(JMSProtocol.class);
    }
}

