/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.worker.jms;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Queue;
import net.orpiske.mpt.common.URLQuery;
import net.orpiske.mpt.common.jms.Client;
import net.orpiske.mpt.maestro.worker.jms.JMSProtocol;
import net.orpiske.mpt.maestro.worker.jms.JMSResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JMSClient
implements Client {
    private static final Logger logger = LoggerFactory.getLogger(JMSClient.class);
    protected String url = null;
    protected Destination destination = null;
    protected Connection connection = null;
    protected int number = -1;

    JMSClient() {
    }

    private String filterURL() {
        int queryStartIndex = this.url.indexOf(63);
        String filteredUrl = queryStartIndex != -1 ? this.url.substring(0, queryStartIndex) : this.url;
        return filteredUrl;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void start() throws Exception {
        Queue destination;
        logger.debug("Starting the JMS client");
        Connection connection = null;
        try {
            URI uri = new URI(this.url);
            String path = uri.getPath();
            String connectionUrl = this.filterURL().replace(path, "");
            URLQuery urlQuery = new URLQuery(uri);
            String protocolName = urlQuery.getString("protocol", JMSProtocol.AMQP.name());
            JMSProtocol protocol = JMSProtocol.valueOf(protocolName);
            logger.debug("JMS client is running test with the protocol {}", (Object)protocolName);
            ConnectionFactory factory = protocol.createConnectionFactory(connectionUrl);
            logger.debug("Connection factory created");
            String type = urlQuery.getString("type", "queue");
            logger.debug("Requested destination type: {}", (Object)type);
            String destinationName = path.substring(1);
            logger.debug("Requested destination name: {}", (Object)destinationName);
            Integer configuredLimitDestinations = urlQuery.getInteger("limitDestinations", null);
            if (configuredLimitDestinations != null) {
                if (this.number < 0) {
                    throw new IllegalArgumentException("JMSClient::number msut be >= 0 when limitDestinations is configured");
                }
                int limitDestinations = configuredLimitDestinations;
                if (limitDestinations <= 0) {
                    throw new IllegalArgumentException("limitDestinations must be > 0");
                }
                logger.info("Client requested a client-specific limit to the number of destinations: {}", (Object)limitDestinations);
                int destinationId = this.number % limitDestinations;
                destinationName = destinationName + '.' + destinationId;
                logger.info("Requested destination name after using client-specific limit to the number of destinations: {}", (Object)destinationName);
            } else {
                logger.info("Requested destination name: {}", (Object)destinationName);
            }
            switch (type) {
                case "queue": {
                    logger.debug("Creating a queue-based destination");
                    destination = protocol.createQueue(destinationName);
                    break;
                }
                case "topic": {
                    logger.debug("Creating a topic-based destination");
                    destination = protocol.createTopic(destinationName);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("not supported destination type: " + type);
                }
            }
            logger.debug("Creating the connection");
            connection = factory.createConnection();
            logger.debug("Connection created successfully");
        }
        catch (Throwable t) {
            logger.warn("Something wrong happened while initializing the JMS client: {}", (Object)t.getMessage(), (Object)t);
            JMSResourceUtil.capturingClose(connection);
            throw t;
        }
        this.destination = destination;
        this.connection = connection;
        this.connection.start();
    }

    public void stop() {
        logger.debug("Stopping the JMS client");
        Throwable t = JMSResourceUtil.capturingClose(this.connection);
        this.connection = null;
        if (t != null) {
            t.printStackTrace();
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

