/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.notes;

import java.io.IOException;
import java.time.Instant;
import net.orpiske.mpt.maestro.notes.MaestroCommand;
import net.orpiske.mpt.maestro.notes.MaestroEventListener;
import net.orpiske.mpt.maestro.notes.MaestroRequest;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessageUnpacker;

public class PingRequest
extends MaestroRequest {
    private long sec;
    private long usec;

    public PingRequest() {
        super(MaestroCommand.MAESTRO_NOTE_PING);
        Instant instant = Instant.now();
        this.sec = instant.getEpochSecond();
        this.usec = instant.getNano() / 1000;
    }

    public PingRequest(MessageUnpacker unpacker) throws IOException {
        super(MaestroCommand.MAESTRO_NOTE_PING);
        this.sec = unpacker.unpackLong();
        this.usec = unpacker.unpackLong();
    }

    public long getSec() {
        return this.sec;
    }

    public void setSec(long sec) {
        this.sec = sec;
    }

    public long getUsec() {
        return this.usec;
    }

    public void setUsec(long usec) {
        this.usec = usec;
    }

    @Override
    protected MessageBufferPacker pack() throws IOException {
        MessageBufferPacker packer = super.pack();
        packer.packLong(this.sec);
        packer.packLong(this.usec);
        return packer;
    }

    @Override
    public void notify(MaestroEventListener visitor) {
        visitor.handle(this);
    }

    @Override
    public String toString() {
        return "PingRequest{sec=" + this.sec + ", usec=" + this.usec + "} " + super.toString();
    }
}

