/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.client;

import java.util.List;
import net.orpiske.mpt.common.exceptions.MaestroConnectionException;
import net.orpiske.mpt.maestro.client.AbstractMaestroExecutor;
import net.orpiske.mpt.maestro.client.MaestroCollector;
import net.orpiske.mpt.maestro.client.MaestroTopics;
import net.orpiske.mpt.maestro.notes.MaestroNote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaestroCollectorExecutor
extends AbstractMaestroExecutor {
    private static final Logger logger = LoggerFactory.getLogger(MaestroCollectorExecutor.class);
    private MaestroCollector maestroCollector = null;

    public MaestroCollectorExecutor(String url) throws MaestroConnectionException {
        super(new MaestroCollector(url));
        logger.trace("Created a new maestro collector executor");
        this.getMaestroPeer().connect();
        this.getMaestroPeer().subscribe(MaestroTopics.MAESTRO_TOPICS);
    }

    public List<MaestroNote> collect() {
        MaestroCollector maestroCollector = (MaestroCollector)super.getMaestroPeer();
        return maestroCollector.collect();
    }

    @Override
    public void stop() {
        super.stop();
        MaestroCollector maestroCollector = (MaestroCollector)super.getMaestroPeer();
        maestroCollector.setRunning(false);
    }
}

