/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.notes;

import java.io.IOException;
import net.orpiske.mpt.maestro.notes.MaestroCommand;
import net.orpiske.mpt.maestro.notes.MaestroNoteType;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;

public class MaestroNote {
    private MaestroNoteType noteType;
    private MaestroCommand maestroCommand;

    public MaestroNote(MaestroNoteType type, MaestroCommand command) {
        this.setNoteType(type);
        this.setMaestroCommand(command);
    }

    public MaestroNoteType getNoteType() {
        return this.noteType;
    }

    protected void setNoteType(MaestroNoteType noteType) {
        this.noteType = noteType;
    }

    public MaestroCommand getMaestroCommand() {
        return this.maestroCommand;
    }

    protected void setMaestroCommand(MaestroCommand maestroCommand) {
        this.maestroCommand = maestroCommand;
    }

    protected MessageBufferPacker pack() throws IOException {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        packer.packShort(this.noteType.getValue());
        packer.packLong(this.maestroCommand.getValue());
        return packer;
    }

    public final byte[] serialize() throws IOException {
        MessageBufferPacker packer = this.pack();
        packer.close();
        return packer.toByteArray();
    }

    public String toString() {
        return "MaestroNote{noteType=" + (Object)((Object)this.noteType) + ", maestroCommand=" + (Object)((Object)this.maestroCommand) + '}';
    }
}

