/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.client;

import java.io.IOException;
import net.orpiske.mpt.maestro.exceptions.MalformedNoteException;
import net.orpiske.mpt.maestro.notes.AbnormalDisconnect;
import net.orpiske.mpt.maestro.notes.FlushRequest;
import net.orpiske.mpt.maestro.notes.Halt;
import net.orpiske.mpt.maestro.notes.InternalError;
import net.orpiske.mpt.maestro.notes.MaestroCommand;
import net.orpiske.mpt.maestro.notes.MaestroEvent;
import net.orpiske.mpt.maestro.notes.MaestroNote;
import net.orpiske.mpt.maestro.notes.MaestroNoteType;
import net.orpiske.mpt.maestro.notes.MaestroNotification;
import net.orpiske.mpt.maestro.notes.MaestroRequest;
import net.orpiske.mpt.maestro.notes.MaestroResponse;
import net.orpiske.mpt.maestro.notes.OkResponse;
import net.orpiske.mpt.maestro.notes.PingRequest;
import net.orpiske.mpt.maestro.notes.PingResponse;
import net.orpiske.mpt.maestro.notes.ProtocolError;
import net.orpiske.mpt.maestro.notes.SetRequest;
import net.orpiske.mpt.maestro.notes.StartInspector;
import net.orpiske.mpt.maestro.notes.StartReceiver;
import net.orpiske.mpt.maestro.notes.StartSender;
import net.orpiske.mpt.maestro.notes.StatsRequest;
import net.orpiske.mpt.maestro.notes.StatsResponse;
import net.orpiske.mpt.maestro.notes.StopInspector;
import net.orpiske.mpt.maestro.notes.StopReceiver;
import net.orpiske.mpt.maestro.notes.StopSender;
import net.orpiske.mpt.maestro.notes.TestFailedNotification;
import net.orpiske.mpt.maestro.notes.TestSuccessfulNotification;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaestroDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(MaestroDeserializer.class);

    private static MaestroNotification deserializeNotification(MessageUnpacker unpacker) throws IOException, MalformedNoteException {
        long tmpCommand = unpacker.unpackLong();
        MaestroCommand command = MaestroCommand.from(tmpCommand);
        switch (command) {
            case MAESTRO_NOTE_NOTIFY_FAIL: {
                return new TestFailedNotification(unpacker);
            }
            case MAESTRO_NOTE_NOTIFY_SUCCESS: {
                return new TestSuccessfulNotification(unpacker);
            }
            case MAESTRO_NOTE_ABNORMAL_DISCONNECT: {
                return new AbnormalDisconnect(unpacker);
            }
        }
        throw new MalformedNoteException("Invalid notification command: " + tmpCommand);
    }

    private static MaestroResponse deserializeResponse(MessageUnpacker unpacker) throws IOException, MalformedNoteException {
        long tmpCommand = unpacker.unpackLong();
        MaestroCommand command = MaestroCommand.from(tmpCommand);
        switch (command) {
            case MAESTRO_NOTE_OK: {
                return new OkResponse();
            }
            case MAESTRO_NOTE_PING: {
                return new PingResponse(unpacker);
            }
            case MAESTRO_NOTE_INTERNAL_ERROR: {
                return new InternalError();
            }
            case MAESTRO_NOTE_PROTOCOL_ERROR: {
                return new ProtocolError();
            }
            case MAESTRO_NOTE_STATS: {
                return new StatsResponse(unpacker);
            }
            case MAESTRO_NOTE_START_RECEIVER: 
            case MAESTRO_NOTE_STOP_RECEIVER: 
            case MAESTRO_NOTE_START_SENDER: 
            case MAESTRO_NOTE_STOP_SENDER: 
            case MAESTRO_NOTE_START_INSPECTOR: 
            case MAESTRO_NOTE_STOP_INSPECTOR: 
            case MAESTRO_NOTE_FLUSH: 
            case MAESTRO_NOTE_SET: 
            case MAESTRO_NOTE_HALT: {
                logger.warn("Unexpected maestro command for a response: {}", (Object)tmpCommand);
            }
        }
        if (command != null) {
            logger.error("Type unknown: " + ((Object)((Object)command)).getClass());
        }
        throw new MalformedNoteException("Invalid response command: " + tmpCommand);
    }

    private static MaestroRequest deserializeRequest(MessageUnpacker unpacker) throws IOException, MalformedNoteException {
        long tmpCommand = unpacker.unpackLong();
        MaestroCommand command = MaestroCommand.from(tmpCommand);
        switch (command) {
            case MAESTRO_NOTE_PING: {
                return new PingRequest(unpacker);
            }
            case MAESTRO_NOTE_FLUSH: {
                return new FlushRequest();
            }
            case MAESTRO_NOTE_STATS: {
                return new StatsRequest();
            }
            case MAESTRO_NOTE_START_RECEIVER: {
                return new StartReceiver();
            }
            case MAESTRO_NOTE_STOP_RECEIVER: {
                return new StopReceiver();
            }
            case MAESTRO_NOTE_START_SENDER: {
                return new StartSender();
            }
            case MAESTRO_NOTE_STOP_SENDER: {
                return new StopSender();
            }
            case MAESTRO_NOTE_START_INSPECTOR: {
                return new StartInspector();
            }
            case MAESTRO_NOTE_STOP_INSPECTOR: {
                return new StopInspector();
            }
            case MAESTRO_NOTE_SET: {
                return new SetRequest(unpacker);
            }
            case MAESTRO_NOTE_HALT: {
                return new Halt();
            }
        }
        throw new MalformedNoteException("Invalid request command: " + tmpCommand);
    }

    public static MaestroEvent deserializeEvent(byte[] bytes) throws IOException, MalformedNoteException {
        Throwable throwable = null;
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);){
            short tmpType = unpacker.unpackShort();
            MaestroNoteType type = MaestroNoteType.from(tmpType);
            switch (type) {
                case MAESTRO_TYPE_REQUEST: {
                    MaestroRequest maestroRequest = MaestroDeserializer.deserializeRequest(unpacker);
                    return maestroRequest;
                }
                case MAESTRO_TYPE_NOTIFICATION: {
                    MaestroNotification maestroNotification = MaestroDeserializer.deserializeNotification(unpacker);
                    return maestroNotification;
                }
            }
            try {
                throw new MalformedNoteException("Invalid event type: " + tmpType);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static MaestroNote deserialize(byte[] bytes) throws IOException, MalformedNoteException {
        Throwable throwable = null;
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);){
            short tmpType = unpacker.unpackShort();
            MaestroNoteType type = MaestroNoteType.from(tmpType);
            switch (type) {
                case MAESTRO_TYPE_REQUEST: {
                    MaestroRequest maestroRequest = MaestroDeserializer.deserializeRequest(unpacker);
                    return maestroRequest;
                }
                case MAESTRO_TYPE_RESPONSE: {
                    MaestroResponse maestroResponse = MaestroDeserializer.deserializeResponse(unpacker);
                    return maestroResponse;
                }
                case MAESTRO_TYPE_NOTIFICATION: {
                    MaestroNotification maestroNotification = MaestroDeserializer.deserializeNotification(unpacker);
                    return maestroNotification;
                }
            }
            try {
                throw new MalformedNoteException("Invalid note type: " + tmpType);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

