/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.client;

import java.io.IOException;
import java.util.UUID;
import net.orpiske.mpt.common.URLUtils;
import net.orpiske.mpt.common.exceptions.MaestroConnectionException;
import net.orpiske.mpt.common.exceptions.MaestroException;
import net.orpiske.mpt.maestro.exceptions.MalformedNoteException;
import net.orpiske.mpt.maestro.notes.MaestroNote;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaestroClient {
    private static final Logger logger = LoggerFactory.getLogger(MaestroClient.class);
    private MqttClient mqttClient;

    public MaestroClient(String url) throws MaestroException {
        String adjustedUrl = URLUtils.sanizeURL((String)url);
        UUID uuid = UUID.randomUUID();
        String clientId = uuid.toString();
        MemoryPersistence memoryPersistence = new MemoryPersistence();
        try {
            this.mqttClient = new MqttClient(adjustedUrl, "maestro-java-" + clientId, (MqttClientPersistence)memoryPersistence);
        }
        catch (MqttException e) {
            throw new MaestroException("Unable create a MQTT client instance : " + e.getMessage(), (Throwable)e);
        }
    }

    public void connect() throws MaestroConnectionException {
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setCleanSession(true);
        try {
            if (!this.mqttClient.isConnected()) {
                this.mqttClient.connect();
            }
        }
        catch (MqttException e) {
            throw new MaestroConnectionException("Unable to establish a connection to Maestro: " + e.getMessage(), (Throwable)e);
        }
    }

    public void disconnect() throws MaestroConnectionException {
        try {
            this.mqttClient.disconnect();
        }
        catch (MqttException e) {
            throw new MaestroConnectionException("Unable to disconnect cleanly from Maestro: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void publish(String topic, MaestroNote note, int qos, boolean retained) throws MalformedNoteException, MaestroConnectionException {
        byte[] bytes;
        try {
            bytes = note.serialize();
        }
        catch (IOException e) {
            throw new MalformedNoteException(e.getMessage());
        }
        try {
            if (!this.mqttClient.isConnected()) {
                logger.warn("The client is disconnected ... reconnecting");
                this.mqttClient.reconnect();
            }
            this.mqttClient.publish(topic, bytes, qos, retained);
        }
        catch (MqttException e) {
            throw new MaestroConnectionException("Unable to publish message: " + e.getMessage(), (Throwable)e);
        }
    }

    public void publish(String topic, MaestroNote note) throws MalformedNoteException, MaestroConnectionException {
        this.publish(topic, note, 0, false);
    }
}

