/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import net.orpiske.mpt.common.URLUtils;
import net.orpiske.mpt.common.exceptions.MaestroConnectionException;
import net.orpiske.mpt.maestro.client.MaestroNoteDeserializer;
import net.orpiske.mpt.maestro.exceptions.MalformedNoteException;
import net.orpiske.mpt.maestro.notes.MaestroNote;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMaestroPeer<T extends MaestroNote>
implements MqttCallback {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMaestroPeer.class);
    private MqttClient inboundEndPoint;
    protected String clientName;
    protected String id;
    private final MaestroNoteDeserializer<? extends T> deserializer;

    public AbstractMaestroPeer(String url, String clientName, MaestroNoteDeserializer<? extends T> deserializer) throws MaestroConnectionException {
        String adjustedUrl = URLUtils.sanizeURL((String)url);
        UUID uuid = UUID.randomUUID();
        String clientId = uuid.toString();
        MemoryPersistence memoryPersistence = new MemoryPersistence();
        this.id = clientId;
        this.clientName = clientName;
        try {
            this.inboundEndPoint = new MqttClient(adjustedUrl, clientName + ".inbound." + clientId, (MqttClientPersistence)memoryPersistence);
            this.inboundEndPoint.setCallback((MqttCallback)this);
        }
        catch (MqttException e) {
            throw new MaestroConnectionException("Unable create a MQTT client instance : " + e.getMessage(), (Throwable)e);
        }
        this.deserializer = deserializer;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void connectionLost(Throwable throwable) {
        logger.warn("Connection lost");
    }

    public boolean isConnected() {
        return this.inboundEndPoint.isConnected();
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    public void connect() throws MaestroConnectionException {
        logger.debug("Connecting to maestro");
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setCleanSession(true);
        connOpts.setKeepAliveInterval(15000);
        try {
            this.inboundEndPoint.connect();
        }
        catch (MqttException e) {
            throw new MaestroConnectionException("Unable to establish a connection to Maestro: " + e.getMessage(), (Throwable)e);
        }
    }

    public void disconnect() throws MaestroConnectionException {
        logger.debug("Disconnecting from maestro");
        try {
            this.inboundEndPoint.disconnect();
        }
        catch (MqttException e) {
            throw new MaestroConnectionException("Unable to disconnect cleanly from Maestro: " + e.getMessage(), (Throwable)e);
        }
    }

    public void subscribe(String[] topics) throws MaestroConnectionException {
        logger.debug("Subscribing to maestro topics {}", (Object)Arrays.toString(topics));
        int[] qos = new int[topics.length];
        for (int i = 0; i < topics.length; ++i) {
            qos[i] = 0;
        }
        try {
            this.inboundEndPoint.subscribe(topics, qos);
        }
        catch (MqttException e) {
            throw new MaestroConnectionException("Unable to subscribe to Maestro topics: " + e.getMessage(), (Throwable)e);
        }
    }

    public void messageArrived(String s, MqttMessage mqttMessage) {
        logger.trace("Message arrived on topic {}", (Object)s);
        byte[] payload = mqttMessage.getPayload();
        try {
            T note = this.deserializer.deserialize(payload);
            logger.trace("Message type: " + note.getClass());
            this.noteArrived(note);
        }
        catch (MalformedNoteException e) {
            logger.error("Invalid message type: " + e.getMessage(), (Throwable)((Object)e));
        }
        catch (IOException e) {
            logger.error("I/O error: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unhandled exception: " + e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void noteArrived(T var1) throws IOException, MaestroConnectionException;

    public abstract boolean isRunning();
}

