/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.client;

import net.orpiske.mpt.common.exceptions.MaestroConnectionException;
import net.orpiske.mpt.maestro.client.AbstractMaestroPeer;
import net.orpiske.mpt.maestro.client.MaestroCollectorExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMaestroExecutor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MaestroCollectorExecutor.class);
    private AbstractMaestroPeer maestroPeer;

    public AbstractMaestroExecutor(AbstractMaestroPeer maestroPeer) throws MaestroConnectionException {
        this.maestroPeer = maestroPeer;
    }

    protected AbstractMaestroPeer getMaestroPeer() {
        return this.maestroPeer;
    }

    public void start(String[] topics) throws MaestroConnectionException {
        logger.debug("Connecting the maestro broker");
        this.maestroPeer.connect();
        this.maestroPeer.subscribe(topics);
    }

    @Override
    public final void run() {
        while (this.maestroPeer.isRunning()) {
            try {
                logger.trace("Waiting for data ...");
                if (!this.maestroPeer.isConnected()) {
                    logger.error("Disconnected from the broker: reconnecting");
                    this.maestroPeer.connect();
                }
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stop() {
        try {
            logger.debug("Disconnecting the peer");
            this.maestroPeer.disconnect();
        }
        catch (MaestroConnectionException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }
}

