/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.orpiske.mpt.common.content.MessageSize;
import net.orpiske.mpt.common.duration.TestDuration;
import net.orpiske.mpt.common.duration.TestDurationBuilder;
import net.orpiske.mpt.common.exceptions.DurationParseException;
import net.orpiske.mpt.common.test.MaestroTestProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProperties
implements MaestroTestProperties {
    private static final Logger logger = LoggerFactory.getLogger(TestProperties.class);
    private String brokerUri;
    private String durationType;
    private long duration;
    private int parallelCount;
    private long messageSize;
    private boolean variableSize;
    private int rate;
    private int fcl;
    private String apiName;
    private String apiVersion;
    private String protocol;
    private int limitDestinations = 1;

    @Override
    public void load(File testProperties) throws IOException {
        logger.debug("Reading properties from {}", (Object)testProperties.getPath());
        Properties prop = new Properties();
        try (FileInputStream in = new FileInputStream(testProperties);){
            prop.load(in);
            this.brokerUri = prop.getProperty("brokerUri");
            this.durationType = prop.getProperty("durationType");
            this.duration = Long.parseLong(prop.getProperty("duration"));
            this.parallelCount = Integer.parseInt(prop.getProperty("parallelCount"));
            this.messageSize = Long.parseLong(prop.getProperty("messageSize"));
            String varSizeStr = prop.getProperty("variableSize");
            if (varSizeStr != null && varSizeStr.equals("1")) {
                this.variableSize = true;
            }
            this.rate = Integer.parseInt(prop.getProperty("rate"));
            String fclStr = prop.getProperty("fcl");
            if (fclStr != null) {
                this.fcl = Integer.parseInt(fclStr);
            }
            this.apiName = prop.getProperty("apiName");
            this.apiVersion = prop.getProperty("apiVersion");
            this.protocol = prop.getProperty("protocol");
            String limitDestinationsStr = prop.getProperty("limitDestinations");
            if (limitDestinationsStr != null) {
                this.limitDestinations = Integer.parseInt(limitDestinationsStr);
            }
        }
        logger.debug("Read properties: {}", (Object)this.toString());
    }

    @Override
    public void write(File testProperties) throws IOException {
        logger.debug("Writing properties to {}", (Object)testProperties.getPath());
        logger.debug("Wrote properties: {}", (Object)this.toString());
        Properties prop = new Properties();
        prop.setProperty("brokerUri", this.brokerUri);
        prop.setProperty("durationType", this.durationType);
        prop.setProperty("duration", Long.toString(this.duration));
        prop.setProperty("parallelCount", Integer.toString(this.parallelCount));
        prop.setProperty("messageSize", Long.toString(this.messageSize));
        prop.setProperty("variableSize", this.variableSize ? "1" : "0");
        prop.setProperty("rate", Integer.toString(this.rate));
        prop.setProperty("fcl", Integer.toString(this.fcl));
        prop.setProperty("apiName", this.apiName);
        prop.setProperty("apiVersion", this.apiVersion);
        prop.setProperty("protocol", this.protocol);
        prop.setProperty("limitDestinations", Integer.toString(this.limitDestinations));
        try (FileOutputStream fos = new FileOutputStream(testProperties);){
            prop.store(fos, "mpt");
        }
    }

    public String getBrokerUri() {
        return this.brokerUri;
    }

    public void setBrokerUri(String brokerUri) {
        this.brokerUri = brokerUri;
    }

    public String getDurationType() {
        return this.durationType;
    }

    public void setDurationType(String durationType) {
        this.durationType = durationType;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setDuration(String durationSpec) throws DurationParseException {
        TestDuration td = TestDurationBuilder.build(durationSpec);
        this.duration = td.getNumericDuration();
        this.durationType = td.durationTypeName();
    }

    public void setParallelCount(int parallelCount) {
        this.parallelCount = parallelCount;
    }

    public void setParallelCount(String parallelCount) {
        this.parallelCount = Integer.parseInt(parallelCount);
    }

    public void setMessageSize(long messageSize) {
        this.messageSize = messageSize;
    }

    public void setMessageSize(String messageSize) {
        if (MessageSize.isVariable(messageSize)) {
            this.setVariableSize(true);
        }
        this.messageSize = MessageSize.toSizeFromSpec(messageSize);
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public void setRate(String rate) {
        this.rate = Integer.parseInt(rate);
    }

    public String getApiName() {
        return this.apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getMessageSize() {
        return this.messageSize;
    }

    public int getRate() {
        return this.rate;
    }

    public int getParallelCount() {
        return this.parallelCount;
    }

    public boolean isVariableSize() {
        return this.variableSize;
    }

    public void setVariableSize(boolean variableSize) {
        this.variableSize = variableSize;
    }

    public int getFcl() {
        return this.fcl;
    }

    public void setFcl(int fcl) {
        this.fcl = fcl;
    }

    public void setFcl(String fcl) {
        this.fcl = Integer.parseInt(fcl);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getLimitDestinations() {
        return this.limitDestinations;
    }

    public void setLimitDestinations(int limitDestinations) {
        this.limitDestinations = limitDestinations;
    }

    public String toString() {
        return "TestProperties{brokerUri='" + this.brokerUri + '\'' + ", durationType='" + this.durationType + '\'' + ", duration=" + this.duration + ", parallelCount=" + this.parallelCount + ", messageSize=" + this.messageSize + ", variableSize=" + this.variableSize + ", rate=" + this.rate + ", fcl=" + this.fcl + ", apiName='" + this.apiName + '\'' + ", apiVersion='" + this.apiVersion + '\'' + ", protocol='" + this.protocol + '\'' + ", limitDestinations=" + this.limitDestinations + '}';
    }
}

