/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.orpiske.mpt.common.test.MaestroTestProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectorProperties
implements MaestroTestProperties {
    private static final Logger logger = LoggerFactory.getLogger(InspectorProperties.class);
    private String jvmName;
    private String jvmVersion;
    private String jvmPackageVersion;
    private String operatingSystemName;
    private String operatingSystemArch;
    private String operatingSystemVersion;
    private int systemCpuCount;
    private long systemMemory;
    private long systemSwap;
    private String productName;
    private String productVersion;

    @Override
    public void load(File testProperties) throws IOException {
        logger.trace("Reading properties from {}", (Object)testProperties.getPath());
        Properties prop = new Properties();
        try (FileInputStream in = new FileInputStream(testProperties);){
            prop.load(in);
            this.jvmName = prop.getProperty("jvmName");
            this.jvmVersion = prop.getProperty("jvmVersion");
            this.jvmPackageVersion = prop.getProperty("jvmPackageVersion");
            this.operatingSystemName = prop.getProperty("operatingSystemName");
            this.operatingSystemArch = prop.getProperty("operatingSystemArch");
            this.operatingSystemVersion = prop.getProperty("operatingSystemVersion");
            this.systemCpuCount = Integer.parseInt(prop.getProperty("systemCpuCount"));
            this.systemMemory = Long.parseLong(prop.getProperty("systemMemory"));
            this.systemSwap = Long.parseLong(prop.getProperty("systemSwap"));
            this.productName = prop.getProperty("productName");
            this.productVersion = prop.getProperty("productVersion");
        }
    }

    @Override
    public void write(File testProperties) throws IOException {
        logger.trace("Writing properties to {}", (Object)testProperties.getPath());
        Properties prop = new Properties();
        prop.setProperty("jvmName", this.jvmName);
        prop.setProperty("jvmVersion", this.jvmVersion);
        prop.setProperty("jvmPackageVersion", this.jvmPackageVersion);
        prop.setProperty("operatingSystemName", this.operatingSystemName);
        prop.setProperty("operatingSystemArch", this.operatingSystemArch);
        prop.setProperty("operatingSystemVersion", this.operatingSystemVersion);
        prop.setProperty("systemCpuCount", Integer.toString(this.systemCpuCount));
        prop.setProperty("systemMemory", Long.toString(this.systemMemory));
        prop.setProperty("systemSwap", Long.toString(this.systemSwap));
        prop.setProperty("productName", this.productName);
        prop.setProperty("productVersion", this.productVersion);
        try (FileOutputStream fos = new FileOutputStream(testProperties);){
            prop.store(fos, "mpt");
        }
    }

    public String getJvmName() {
        return this.jvmName;
    }

    public void setJvmName(String jvmName) {
        this.jvmName = jvmName;
    }

    public String getJvmVersion() {
        return this.jvmVersion;
    }

    public void setJvmVersion(String jvmVersion) {
        this.jvmVersion = jvmVersion;
    }

    public String getJvmPackageVersion() {
        return this.jvmPackageVersion;
    }

    public void setJvmPackageVersion(String jvmPackageVersion) {
        this.jvmPackageVersion = jvmPackageVersion;
    }

    public String getOperatingSystemName() {
        return this.operatingSystemName;
    }

    public void setOperatingSystemName(String operatingSystemName) {
        this.operatingSystemName = operatingSystemName;
    }

    public String getOperatingSystemArch() {
        return this.operatingSystemArch;
    }

    public void setOperatingSystemArch(String operatingSystemArch) {
        this.operatingSystemArch = operatingSystemArch;
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public void setOperatingSystemVersion(String operatingSystemVersion) {
        this.operatingSystemVersion = operatingSystemVersion;
    }

    public int getSystemCpuCount() {
        return this.systemCpuCount;
    }

    public void setSystemCpuCount(int systemCpuCount) {
        this.systemCpuCount = systemCpuCount;
    }

    public long getSystemMemory() {
        return this.systemMemory;
    }

    public void setSystemMemory(long systemMemory) {
        this.systemMemory = systemMemory;
    }

    public long getSystemSwap() {
        return this.systemSwap;
    }

    public void setSystemSwap(long systemSwap) {
        this.systemSwap = systemSwap;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }
}

