/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common.duration;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.util.concurrent.TimeUnit;
import net.orpiske.mpt.common.duration.EpochMicroClock;
import net.orpiske.mpt.common.duration.timespec;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class JnaDirectNativeClock
implements EpochMicroClock {
    private static final int TIMESPEC_REQUIRED_CAPACITY;
    private final DirectBuffer buffer;
    private final Pointer pointer;

    public static native void clock_gettime(int var0, Pointer var1);

    public JnaDirectNativeClock() {
        int requiredCapacity = TIMESPEC_REQUIRED_CAPACITY;
        this.buffer = new UnsafeBuffer(BufferUtil.allocateDirectAligned((int)requiredCapacity, (int)8));
        this.pointer = Pointer.createConstant(this.buffer.addressOffset());
    }

    public long currentTimeNanos() {
        JnaDirectNativeClock.clock_gettime(0, this.pointer);
        long tv_sec = this.buffer.getLong(0);
        long tv_ns = this.buffer.getLong(8);
        return TimeUnit.SECONDS.toNanos(tv_sec) + tv_ns;
    }

    public long currentTimeMicros() {
        JnaDirectNativeClock.clock_gettime(0, this.pointer);
        long tv_sec = this.buffer.getLong(0);
        long tv_ns = this.buffer.getLong(8);
        return TimeUnit.SECONDS.toMicros(tv_sec) + tv_ns / 1000L;
    }

    @Override
    public long microTime() {
        return this.currentTimeMicros();
    }

    static {
        System.setProperty("agrona.disable.bounds.checks", Boolean.TRUE.toString());
        Native.register(Platform.C_LIBRARY_NAME);
        timespec.ByValue timeSpec = new timespec.ByValue();
        TIMESPEC_REQUIRED_CAPACITY = timeSpec.size();
    }
}

