/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.utils.contrib.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import net.orpiske.mpt.utils.contrib.resource.Resource;
import net.orpiske.mpt.utils.contrib.resource.ResourceExchange;
import net.orpiske.mpt.utils.contrib.resource.ResourceInfo;
import net.orpiske.mpt.utils.contrib.resource.exceptions.ResourceExchangeException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResourceExchange
implements ResourceExchange {
    private static final Logger logger = LoggerFactory.getLogger(HttpResourceExchange.class);
    private AbstractHttpClient httpClient = new DefaultHttpClient();

    public HttpResourceExchange() {
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(this.httpClient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        this.httpClient.setRoutePlanner((HttpRoutePlanner)routePlanner);
    }

    public HttpResourceExchange(HashMap<String, Object> connectionProperties) {
        String proxy = (String)connectionProperties.get("HTTP_PROXY");
        Integer port = (Integer)connectionProperties.get("PROXY_PORT");
        if (proxy != null) {
            HttpHost proxyHost = new HttpHost(proxy, port.intValue());
            this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
        }
    }

    private long getLastModified(HttpResponse response) {
        Date date;
        Header header = response.getFirstHeader("Last-Modified");
        if (header == null) {
            logger.warn("The server does not provide the last modified information");
            return 0L;
        }
        String tmp = header.getValue();
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
        try {
            date = dateFormat.parse(tmp);
        }
        catch (ParseException e) {
            logger.warn("The last modified date provided by the server is invalid");
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return 0L;
        }
        return date.getTime();
    }

    private long getContentLength(HttpResponse response) {
        Header header = response.getFirstHeader("Content-Length");
        String tmp = header.getValue();
        try {
            return Long.parseLong(tmp);
        }
        catch (NumberFormatException e) {
            logger.warn("The server provided an invalid content length value");
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return 0L;
        }
    }

    @Override
    public ResourceInfo info(URI uri) throws ResourceExchangeException {
        HttpHead httpHead = new HttpHead(uri);
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpHead);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                long length = this.getContentLength(response);
                logger.debug("Reading " + length + " bytes from the server");
                ResourceInfo ret = new ResourceInfo();
                ret.setSize(length);
                ret.setLastModified(this.getLastModified(response));
                return ret;
            }
            switch (statusCode) {
                case 404: {
                    throw new ResourceExchangeException("Remote file not found: " + uri.toString(), 404);
                }
                case 400: {
                    throw new ResourceExchangeException("The client sent a bad request", 404);
                }
                case 403: {
                    throw new ResourceExchangeException("Accessing the resource is forbidden", 404);
                }
                case 401: {
                    throw new ResourceExchangeException("Unauthorized", 404);
                }
                case 500: {
                    throw new ResourceExchangeException("Internal server error", 404);
                }
            }
            throw new ResourceExchangeException("Unable to download file: http status code " + statusCode, 404);
        }
        catch (ClientProtocolException e) {
            throw new ResourceExchangeException("Unhandled protocol error: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ResourceExchangeException("I/O error: " + e.getMessage(), e);
        }
    }

    @Override
    public Resource<InputStream> get(URI uri) throws ResourceExchangeException {
        block12: {
            HttpGet httpget = new HttpGet(uri);
            try {
                HttpResponse response = this.httpClient.execute((HttpUriRequest)httpget);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        logger.debug("Reading " + entity.getContentLength() + " bytes from the server");
                        Resource<InputStream> ret = new Resource<InputStream>();
                        ret.setPayload(entity.getContent());
                        ResourceInfo info = new ResourceInfo();
                        info.setSize(entity.getContentLength());
                        info.setLastModified(this.getLastModified(response));
                        ret.setResourceInfo(info);
                        return ret;
                    }
                    break block12;
                }
                switch (statusCode) {
                    case 404: {
                        throw new ResourceExchangeException("Remote file not found", 404);
                    }
                    case 400: {
                        throw new ResourceExchangeException("The client sent a bad request", 400);
                    }
                    case 403: {
                        throw new ResourceExchangeException("Accessing the resource is forbidden", 403);
                    }
                    case 401: {
                        throw new ResourceExchangeException("Unauthorized", 401);
                    }
                    case 500: {
                        throw new ResourceExchangeException("Internal server error", 500);
                    }
                }
                throw new ResourceExchangeException("Unable to download file: http status code " + statusCode);
            }
            catch (ClientProtocolException e) {
                throw new ResourceExchangeException("Unhandled protocol error: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ResourceExchangeException("I/O error: " + e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public void release() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    public static class Properties {
        public static final String HTTP_PROXY = "HTTP_PROXY";
        public static final String PROXY_PORT = "PROXY_PORT";
    }
}

