/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.utils.contrib.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import net.orpiske.mpt.utils.contrib.resource.Resource;
import net.orpiske.mpt.utils.contrib.resource.ResourceExchange;
import net.orpiske.mpt.utils.contrib.resource.ResourceInfo;
import net.orpiske.mpt.utils.contrib.resource.exceptions.ResourceExchangeException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileResourceExchange
implements ResourceExchange {
    private FileInputStream inputStream;

    @Override
    public Resource<InputStream> get(URI uri) throws ResourceExchangeException {
        File file = new File(uri);
        Resource<InputStream> ret = new Resource<InputStream>();
        try {
            this.inputStream = FileUtils.openInputStream((File)file);
            ret.setPayload(this.inputStream);
            ResourceInfo info = new ResourceInfo();
            info.setSize(FileUtils.sizeOf((File)file));
            info.setLastModified(file.lastModified());
            ret.setResourceInfo(info);
        }
        catch (IOException e) {
            throw new ResourceExchangeException("I/O error: " + e.getMessage(), e);
        }
        return ret;
    }

    @Override
    public ResourceInfo info(URI uri) throws ResourceExchangeException {
        File file = new File(uri);
        ResourceInfo ret = new ResourceInfo();
        ret.setSize(FileUtils.sizeOf((File)file));
        ret.setLastModified(file.lastModified());
        return ret;
    }

    @Override
    public void release() {
        IOUtils.closeQuietly((InputStream)this.inputStream);
    }
}

