/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import net.orpiske.mpt.utils.contrib.net.URLUtils;
import net.orpiske.mpt.utils.contrib.resource.HttpResourceExchange;
import net.orpiske.mpt.utils.contrib.resource.Resource;
import net.orpiske.mpt.utils.contrib.resource.ResourceInfo;
import net.orpiske.mpt.utils.contrib.resource.exceptions.ResourceExchangeException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    private static final Logger logger = LoggerFactory.getLogger(Downloader.class);

    private static void copy(Resource<InputStream> resource, OutputStream output) throws IOException {
        long total = resource.getResourceInfo().getSize();
        logger.info("Downloading {} from the server", (Object)FileUtils.byteCountToDisplaySize((long)total));
        InputStream input = resource.getPayload();
        IOUtils.copy((InputStream)input, (OutputStream)output);
        logger.info("Download completed successfully");
        output.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File setupOutputFile(String url, String destDir, boolean overwrite) throws MalformedURLException, URISyntaxException, IOException {
        String fileName = URLUtils.getFilename(url);
        String fullName = destDir + File.separator + fileName;
        File outputFile = new File(fullName);
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new IOException("Unable to create output directory " + fullName);
        }
        if (!outputFile.exists()) {
            if (outputFile.createNewFile()) return outputFile;
            throw new IOException("Unable to create file " + fullName);
        }
        if (overwrite) {
            if (!outputFile.delete()) throw new IOException("Unable to delete existing file " + fullName);
            if (outputFile.createNewFile()) return outputFile;
            throw new IOException("Unable to create file " + fullName);
        }
        logger.info("Destination file " + fullName + " already exists");
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveDownload(File outputFile, Resource<InputStream> resource) throws IOException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(outputFile);
            Downloader.copy(resource, output);
            long lastModified = resource.getResourceInfo().getLastModified();
            if (!outputFile.setLastModified(lastModified)) {
                logger.info("Unable to set the last modified date for " + outputFile.getPath());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            IOUtils.closeQuietly((InputStream)resource.getPayload());
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)output);
        IOUtils.closeQuietly((InputStream)resource.getPayload());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String url, String destDir, boolean overwrite) throws ResourceExchangeException {
        File outputFile = null;
        try {
            URI uri = new URI(url);
            outputFile = Downloader.setupOutputFile(url, destDir, overwrite);
            HttpResourceExchange resourceExchange = new HttpResourceExchange();
            ResourceInfo resourceInfo = resourceExchange.info(uri);
            try {
                long outSize = FileUtils.sizeOf((File)outputFile);
                long sourceSize = resourceInfo.getSize();
                if (sourceSize == outSize) {
                    logger.info("Destination file and source file appears to be the same. Using cached file instead.");
                } else {
                    Resource<InputStream> resource = resourceExchange.get(uri);
                    Downloader.saveDownload(outputFile, resource);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Downloaded " + outputFile.getPath());
                    }
                }
            }
            finally {
                logger.debug("Releasing resources");
                resourceExchange.release();
            }
        }
        catch (URISyntaxException e) {
            if (outputFile != null) {
                outputFile.delete();
            }
            throw new ResourceExchangeException("Invalid URI: " + url, e);
        }
        catch (Exception e) {
            System.err.println("Removing file " + outputFile.getPath());
            if (outputFile != null) {
                outputFile.delete();
            }
            throw new ResourceExchangeException("I/O error: " + e.getMessage(), e);
        }
    }

    public static void download(String url, String destDir) throws ResourceExchangeException {
        Downloader.download(url, destDir, false);
    }
}

