/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.exporter.main;

import net.orpiske.mpt.common.LogConfigurator;
import net.orpiske.mpt.exporter.main.MaestroExporter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static CommandLine cmdLine;
    private static Options options;
    private static String maestroUrl;
    private static int port;

    private static void help(Options options, int code) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("maestro-java", options);
        System.exit(code);
    }

    private static void processCommand(String[] args) {
        String portTmp;
        PosixParser parser = new PosixParser();
        options = new Options();
        options.addOption("h", "help", false, "prints the help");
        options.addOption("m", "maestro-url", true, "maestro URL to connect to");
        options.addOption("p", "port", true, "port used to export metrics (default to 9200)");
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            Main.help(options, -1);
        }
        if (cmdLine.hasOption("help")) {
            Main.help(options, 0);
        }
        if ((maestroUrl = cmdLine.getOptionValue('m')) == null) {
            Main.help(options, -1);
        }
        if ((portTmp = cmdLine.getOptionValue('p')) != null) {
            port = Integer.parseInt(portTmp);
        }
    }

    public static void main(String[] args) {
        Main.processCommand(args);
        LogConfigurator.defaultForDaemons();
        try {
            MaestroExporter exporter = new MaestroExporter(maestroUrl);
            exporter.run(port);
            System.exit(0);
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(Main.class);
            logger.error("Unable to start Maestro exporter: {}", (Object)e.getMessage(), (Object)e);
            System.exit(1);
        }
    }

    static {
        port = 9200;
    }
}

