/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.exporter.main;

import io.prometheus.client.Counter;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.List;
import net.orpiske.mpt.common.exceptions.MaestroConnectionException;
import net.orpiske.mpt.common.exceptions.MaestroException;
import net.orpiske.mpt.exporter.collectors.ConnectionCount;
import net.orpiske.mpt.exporter.collectors.MessageCount;
import net.orpiske.mpt.exporter.collectors.PingInfo;
import net.orpiske.mpt.exporter.collectors.RateCount;
import net.orpiske.mpt.maestro.Maestro;
import net.orpiske.mpt.maestro.notes.AbnormalDisconnect;
import net.orpiske.mpt.maestro.notes.MaestroNote;
import net.orpiske.mpt.maestro.notes.PingResponse;
import net.orpiske.mpt.maestro.notes.StatsResponse;
import net.orpiske.mpt.maestro.notes.TestFailedNotification;
import net.orpiske.mpt.maestro.notes.TestSuccessfulNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaestroExporter {
    private static final Logger logger = LoggerFactory.getLogger(MaestroExporter.class);
    private static final MessageCount messageCounter = MessageCount.getInstance();
    private static final RateCount rateCounter = RateCount.getInstance();
    private static final ConnectionCount connectionCounter = ConnectionCount.getInstance();
    private static final PingInfo pingInfo = PingInfo.getInstance();
    private static final Counter failures = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("maestro_test_failures")).help("Test failures")).register();
    private static final Counter successes = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("maestro_test_success")).help("Test success")).register();
    private static final Counter abnormal = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("maestro_peer_abnormal_disconnect")).help("Abnormal disconnect count")).register();
    private boolean running = true;
    private Maestro maestro = null;

    public MaestroExporter(String maestroUrl) throws MaestroException {
        this.maestro = new Maestro(maestroUrl);
        messageCounter.register();
        rateCounter.register();
        connectionCounter.register();
        pingInfo.register();
    }

    private void processNotes(List<MaestroNote> notes) {
        for (MaestroNote note : notes) {
            if (note instanceof StatsResponse) {
                StatsResponse statsResponse = (StatsResponse)note;
                rateCounter.record(statsResponse);
                messageCounter.record(statsResponse);
                connectionCounter.record(statsResponse);
            } else if (note instanceof PingResponse) {
                PingResponse pingResponse = (PingResponse)note;
                pingInfo.record(pingResponse);
            } else if (note instanceof TestFailedNotification) {
                failures.inc();
            } else if (note instanceof TestSuccessfulNotification) {
                successes.inc();
            } else if (note instanceof AbnormalDisconnect) {
                abnormal.inc();
            }
            logger.trace("Note: {}", (Object)note.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(int port) throws MaestroConnectionException, IOException {
        logger.info("Exporting metrics on 0.0.0.0:" + port);
        HTTPServer server = null;
        try {
            server = new HTTPServer(port);
            while (this.running) {
                logger.debug("Sending requests");
                this.maestro.statsRequest();
                this.maestro.pingRequest();
                List notes = this.maestro.collect(1000L, 5);
                if (notes != null) {
                    this.processNotes(notes);
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
        return 0;
    }
}

