/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.exporter.collectors;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.orpiske.mpt.common.NodeUtils;
import net.orpiske.mpt.maestro.notes.PingResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingInfo
extends Collector {
    private static final Logger logger = LoggerFactory.getLogger(PingInfo.class);
    private static PingInfo instance = null;
    private Map<String, PingResponse> records = new HashMap<String, PingResponse>();

    private PingInfo() {
    }

    public static synchronized PingInfo getInstance() {
        if (instance == null) {
            instance = new PingInfo();
        }
        return instance;
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        GaugeMetricFamily labeledGauge = new GaugeMetricFamily("maestro_ping", "Ping", Arrays.asList("peer", "type"));
        logger.trace("Number of values to process: {}", (Object)this.records.values().size());
        for (PingResponse pingResponse : this.records.values()) {
            String nodeName = pingResponse.getName();
            String type = NodeUtils.getTypeFromName((String)nodeName);
            logger.trace("Adding record for {}/{}", (Object)pingResponse.getName(), (Object)pingResponse.getId());
            labeledGauge.addMetric(Arrays.asList(pingResponse.getName(), type), (double)pingResponse.getElapsed());
        }
        mfs.add((Collector.MetricFamilySamples)labeledGauge);
        this.records.clear();
        return mfs;
    }

    public void record(PingResponse pingResponse) {
        logger.trace("Recording ping for {}/{}", (Object)pingResponse.getName(), (Object)pingResponse.getId());
        this.records.put(pingResponse.getId(), pingResponse);
    }
}

