/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.exporter.collectors;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.orpiske.mpt.maestro.notes.StatsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCount
extends Collector {
    private static final Logger logger = LoggerFactory.getLogger(MessageCount.class);
    private static MessageCount instance = null;
    private Map<String, StatsResponse> records = new HashMap<String, StatsResponse>();

    private MessageCount() {
    }

    public static synchronized MessageCount getInstance() {
        if (instance == null) {
            instance = new MessageCount();
        }
        return instance;
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        GaugeMetricFamily labeledGauge = new GaugeMetricFamily("maestro_message_count", "Message count", Arrays.asList("peer", "type"));
        logger.trace("Number of values to process: {}", (Object)this.records.values().size());
        for (StatsResponse stats : this.records.values()) {
            logger.trace("Adding record for {}/{}", (Object)stats.getName(), (Object)stats.getId());
            labeledGauge.addMetric(Arrays.asList(stats.getName(), stats.getRole()), (double)stats.getCount());
        }
        mfs.add((Collector.MetricFamilySamples)labeledGauge);
        this.records.clear();
        return mfs;
    }

    public void record(StatsResponse stats) {
        logger.trace("Recording message count for {}/{}", (Object)stats.getName(), (Object)stats.getId());
        this.records.put(stats.getId(), stats);
    }
}

