/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.main.actions;

import net.orpiske.mpt.main.actions.Action;
import net.orpiske.mpt.reports.ReportGenerator;
import net.orpiske.mpt.reports.plotter.HdrPlotterWrapper;
import net.orpiske.mpt.reports.plotter.PlotterWrapperFactory;
import net.orpiske.mpt.reports.processors.DiskCleaner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportAction
extends Action {
    private static final String DEFAULT_TIME_UNIT = "1000";
    private CommandLine cmdLine;
    private Options options;
    private String directory;
    private boolean clean;
    private HdrPlotterWrapperFactory hdrPlotterWrapperFactory;

    public ReportAction(String[] args) {
        this.processCommand(args);
    }

    @Override
    protected void processCommand(String[] args) {
        PosixParser parser = new PosixParser();
        this.options = new Options();
        this.options.addOption("h", "help", false, "prints the help");
        this.options.addOption("d", "directory", true, "the directory to generate the report");
        this.options.addOption("l", "log-level", true, "the log level to use [trace, debug, info, warn]");
        this.options.addOption("C", "clean", false, "clean the report directory after processing");
        this.options.addOption("r", "unit-rate", false, "unit-rate to use [default: 1000]");
        try {
            this.cmdLine = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            this.help(this.options, -1);
        }
        if (this.cmdLine.hasOption("help")) {
            this.help(this.options, 0);
        }
        this.directory = this.cmdLine.getOptionValue('d');
        if (this.directory == null) {
            System.err.println("The input directory is a required option");
            this.help(this.options, 1);
        }
        String logLevel = this.cmdLine.getOptionValue('l');
        this.configureLogLevel(logLevel);
        this.clean = this.cmdLine.hasOption('C');
        String timeUnit = this.cmdLine.getOptionValue('r');
        if (timeUnit == null) {
            timeUnit = DEFAULT_TIME_UNIT;
        }
        this.hdrPlotterWrapperFactory = new HdrPlotterWrapperFactory(timeUnit);
    }

    @Override
    public int run() {
        try {
            ReportGenerator reportGenerator = new ReportGenerator(this.directory);
            if (this.clean) {
                reportGenerator.getPostProcessors().add(new DiskCleaner());
            }
            reportGenerator.setHdrPlotterWrapperFactory((PlotterWrapperFactory)this.hdrPlotterWrapperFactory);
            reportGenerator.generate();
            return 0;
        }
        catch (Exception e) {
            System.err.println("Unable to generate the performance test reports");
            e.printStackTrace();
            return 1;
        }
    }

    private static class HdrPlotterWrapperFactory
    implements PlotterWrapperFactory<HdrPlotterWrapper> {
        private static final Logger logger = LoggerFactory.getLogger(HdrPlotterWrapperFactory.class);
        private String unitRate;

        public HdrPlotterWrapperFactory(String unitRate) {
            this.unitRate = unitRate;
            logger.info("Creating a custom HDR Plotter Factory");
        }

        public HdrPlotterWrapper newPlotterWrapper() {
            HdrPlotterWrapper ret = new HdrPlotterWrapper(this.unitRate);
            return ret;
        }
    }
}

