/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.main.actions;

import java.io.IOException;
import java.util.List;
import net.orpiske.mpt.common.exceptions.MaestroException;
import net.orpiske.mpt.maestro.Maestro;
import net.orpiske.mpt.maestro.notes.MaestroNote;
import net.orpiske.mpt.main.actions.Action;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class MaestroAction
extends Action {
    private CommandLine cmdLine;
    private Options options;
    private String maestroUrl;
    private String command;

    public MaestroAction(String[] args) {
        this.processCommand(args);
    }

    @Override
    protected void processCommand(String[] args) {
        PosixParser parser = new PosixParser();
        this.options = new Options();
        this.options.addOption("h", "help", false, "prints the help");
        this.options.addOption("m", "maestro-url", true, "maestro URL to connect to");
        this.options.addOption("c", "command", true, "maestro command [ping, flush, stats]");
        try {
            this.cmdLine = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            this.help(this.options, -1);
        }
        if (this.cmdLine.hasOption("help")) {
            this.help(this.options, 0);
        }
        this.maestroUrl = this.cmdLine.getOptionValue('m');
        if (this.maestroUrl == null) {
            this.help(this.options, -1);
        }
        this.command = this.cmdLine.getOptionValue('c');
        if (this.command == null) {
            this.help(this.options, -1);
        }
    }

    @Override
    public int run() {
        Maestro maestro = null;
        try {
            maestro = new Maestro(this.maestroUrl);
            switch (this.command) {
                case "ping": {
                    maestro.pingRequest();
                    break;
                }
                case "flush": {
                    maestro.flushRequest();
                    break;
                }
                case "stats": {
                    maestro.statsRequest();
                    break;
                }
                case "halt": {
                    maestro.halt();
                    break;
                }
                case "stop": {
                    maestro.stopSender();
                    maestro.stopReceiver();
                    maestro.stopInspector();
                }
            }
            List replies = maestro.collect(1000L, 10);
            for (MaestroNote note : replies) {
                System.out.println("Reply: " + note);
            }
            return 0;
        }
        catch (MaestroException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        return 1;
    }
}

