/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.main.actions;

import net.orpiske.mpt.main.actions.Action;
import net.orpiske.mpt.reports.ReportsDownloader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class DownloadAction
extends Action {
    private CommandLine cmdLine;
    private Options options;
    private String directory;
    private String[] servers;
    private String result;
    private int from;
    private int to;

    public DownloadAction(String[] args) {
        this.processCommand(args);
    }

    @Override
    protected void processCommand(String[] args) {
        String serverList;
        PosixParser parser = new PosixParser();
        this.options = new Options();
        this.options.addOption("h", "help", false, "prints the help");
        this.options.addOption("d", "directory", true, "the directory to generate the report");
        this.options.addOption("l", "log-level", true, "the log level to use [trace, debug, info, warn]");
        this.options.addOption("f", "from-test", true, "the initial test execution number");
        this.options.addOption("t", "to-test", true, "the final test execution number");
        this.options.addOption("s", "servers", true, "a command separated list of servers");
        this.options.addOption("r", "result", true, "the result to assign to the downloaded files [success,failed]");
        try {
            this.cmdLine = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            this.help(this.options, -1);
        }
        if (this.cmdLine.hasOption("help")) {
            this.help(this.options, 0);
        }
        this.directory = this.cmdLine.getOptionValue('d');
        if (this.directory == null) {
            System.err.println("The input directory is a required option");
            this.help(this.options, 1);
        }
        try {
            this.from = Integer.parseInt(this.cmdLine.getOptionValue('f'));
            this.to = Integer.parseInt(this.cmdLine.getOptionValue('t'));
        }
        catch (Exception e) {
            this.help(this.options, 1);
        }
        if (this.to < this.from) {
            System.err.println("The 'from' must not be smaller than 'to'");
            this.help(this.options, 1);
        }
        if ((serverList = this.cmdLine.getOptionValue('s')) == null) {
            System.err.println("The 'servers' option is required");
            this.help(this.options, 1);
        }
        this.servers = serverList.split(",");
        this.result = this.cmdLine.getOptionValue('r');
        if (this.result == null) {
            this.result = "success";
        }
        String logLevel = this.cmdLine.getOptionValue('l');
        this.configureLogLevel(logLevel);
    }

    @Override
    public int run() {
        try {
            for (String server : this.servers) {
                ReportsDownloader rd = new ReportsDownloader(this.directory);
                rd.setReportTypeDir(this.result);
                int i = this.from;
                do {
                    String resourcePath = Integer.toString(i);
                    System.out.println("Downloading reports from http://" + server + "/" + resourcePath);
                    rd.setTestNum(i);
                    rd.downloadAny(server, resourcePath + "/");
                } while (++i <= this.to);
            }
            return 0;
        }
        catch (Exception e) {
            System.err.println("Unable to generate the performance test reports");
            e.printStackTrace();
            return 1;
        }
    }
}

