/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.main.actions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import net.orpiske.mpt.data.rate.RateToHistogram;
import net.orpiske.mpt.main.actions.Action;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class DataAction
extends Action {
    private CommandLine cmdLine;
    private Options options;
    private String input;
    private String output;

    public DataAction(String[] args) {
        this.processCommand(args);
    }

    @Override
    protected void processCommand(String[] args) {
        PosixParser parser = new PosixParser();
        this.options = new Options();
        this.options.addOption("h", "help", false, "prints the help");
        this.options.addOption("a", "action", true, "the action to execute [rate-to-histogram]");
        this.options.addOption("i", "input", true, "the input filename");
        this.options.addOption("o", "output", true, "the output filename (if none, will print to stdout)");
        try {
            this.cmdLine = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            this.help(this.options, -1);
        }
        if (this.cmdLine.hasOption("help")) {
            this.help(this.options, 0);
        }
        this.input = this.cmdLine.getOptionValue('i');
        if (this.input == null) {
            System.err.println("The input filename is a required option");
            this.help(this.options, 1);
        }
        this.output = this.cmdLine.getOptionValue('o');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run() {
        PrintStream ps = System.out;
        if (this.output != null) {
            FileOutputStream fos;
            File outputFile = new File(this.output);
            try {
                fos = new FileOutputStream(outputFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return 1;
            }
            ps = new PrintStream(fos);
        }
        try {
            RateToHistogram.convert(this.input, ps);
            int outputFile = 0;
            return outputFile;
        }
        catch (IOException e) {
            System.err.println("Error converting rate to histogram: " + e.getMessage());
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            ps.close();
        }
    }
}

