/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.main;

import java.util.Arrays;
import net.orpiske.mpt.main.actions.Action;
import net.orpiske.mpt.main.actions.DataAction;
import net.orpiske.mpt.main.actions.DownloadAction;
import net.orpiske.mpt.main.actions.MaestroAction;
import net.orpiske.mpt.main.actions.ReportAction;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class Main {
    private static CommandLine cmdLine;
    private static Options options;
    private static String url;

    private static void help(int code) {
        System.out.println("Usage: maestro-cli <action>\n");
        System.out.println("Actions:");
        System.out.println("   download");
        System.out.println("   report");
        System.out.println("   data");
        System.out.println("   download");
        System.out.println("   maestro");
        System.out.println("----------");
        System.out.println("   help");
        System.out.println("   --version");
        System.exit(code);
    }

    public static void main(String[] args) {
        Action action;
        if (args.length == 0) {
            System.err.println("The action is missing!");
            Main.help(1);
        } else {
            System.out.println("Running " + args[0]);
        }
        String first = args[0];
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        if (first.equals("help")) {
            Main.help(1);
        }
        switch (first) {
            case "data": {
                action = new DataAction(newArgs);
                break;
            }
            case "report": {
                action = new ReportAction(newArgs);
                break;
            }
            case "maestro": {
                action = new MaestroAction(newArgs);
                break;
            }
            case "download": {
                action = new DownloadAction(newArgs);
                break;
            }
            default: {
                Main.help(1);
                return;
            }
        }
        System.exit(action.run());
    }
}

