/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.data.rate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.zip.GZIPInputStream;
import org.HdrHistogram.Histogram;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.io.IOUtils;

public class RateToHistogram {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("\"yyyy-MM-dd HH:mm:ss.SSSSSS\"".replace("\"", "")).withZone(ZoneId.systemDefault());

    public static void convert(String fileName, PrintStream printStream) throws IOException {
        Histogram histogram = new Histogram(3);
        RateToHistogram.appendLatenciesTo(fileName, histogram);
        System.out.println("Latencies reported in MILLISECONDS");
        histogram.outputPercentileDistribution(printStream, Double.valueOf(1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendLatenciesTo(String fileName, Histogram histogram) throws IOException {
        boolean compressed = fileName.endsWith(".gz");
        File file = new File(fileName);
        InputStream inputStream = compressed ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
        try (InputStreamReader in = new InputStreamReader(inputStream);){
            RateToHistogram.rebuildHistogram(in, histogram, inputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private static void rebuildHistogram(Reader in, Histogram histogram, InputStream inputStream) throws IOException {
        long lines = 0L;
        CSVParser records = CSVFormat.RFC4180.withCommentMarker('#').withFirstRecordAsHeader().withRecordSeparator(';').withQuote('\"').withQuoteMode(QuoteMode.NON_NUMERIC).parse(in);
        for (CSVRecord record : records) {
            LocalDateTime end;
            LocalDateTime start = LocalDateTime.parse(record.get(0), dateTimeFormatter);
            if (start.isAfter(end = LocalDateTime.parse(record.get(1), dateTimeFormatter))) {
                System.err.println("ERROR Line [" + lines + "]:\t" + start + " > " + end);
                continue;
            }
            long microseconds = ChronoUnit.MICROS.between(start, end);
            histogram.recordValue(microseconds);
        }
    }
}

