/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mdp.plot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.orpiske.mdp.plot.RateData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatePropertyWriter {
    private static final Logger logger = LoggerFactory.getLogger(RatePropertyWriter.class);

    private RatePropertyWriter() {
    }

    public static void write(RateData rateData, File directory) throws IOException {
        logger.trace("Writing properties to {}/rate.properties", (Object)directory.getPath());
        Properties prop = new Properties();
        prop.setProperty("rateGeometricMean", Double.toString(rateData.getGeometricMean()));
        prop.setProperty("rateMax", Double.toString(rateData.getMax()));
        prop.setProperty("rateMin", Double.toString(rateData.getMin()));
        prop.setProperty("rateStandardDeviation", Double.toString(rateData.getStandardDeviation()));
        prop.setProperty("rateSamples", Double.toString(rateData.getNumberOfSamples()));
        prop.setProperty("rateErrorCount", Long.toString(rateData.getErrorCount()));
        prop.setProperty("rateSkipCount", Long.toString(rateData.getSkipCount()));
        try (FileOutputStream fos = new FileOutputStream(new File(directory, "rate.properties"));){
            prop.store(fos, "mpt-data-plotter");
        }
    }
}

