/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mdp.plot;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import net.orpiske.mdp.plot.exceptions.MptEmptyDataSet;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.colors.ChartColor;
import org.knowm.xchart.style.colors.XChartSeriesColors;
import org.knowm.xchart.style.lines.SeriesLines;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class RatePlotter {
    private static final String SERIES_NAME = "Throughput rate";
    private String baseName;
    private int outputWidth = 1200;
    private int outputHeight = 700;
    private boolean plotGridLinesVisible = true;

    public RatePlotter(String baseName) {
        this.baseName = baseName;
    }

    private XYChart buildCommonChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(this.outputWidth)).height(this.outputHeight)).title(SERIES_NAME)).xAxisTitle("Time").yAxisTitle("Rate").build();
        ((XYStyler)chart.getStyler()).setPlotBackgroundColor(ChartColor.getAWTColor((ChartColor)ChartColor.WHITE));
        ((XYStyler)chart.getStyler()).setChartBackgroundColor(Color.WHITE);
        ((XYStyler)chart.getStyler()).setChartTitleBoxBackgroundColor(new Color(0, 222, 0));
        Font font = new Font("Verdana", 0, 12);
        ((XYStyler)chart.getStyler()).setBaseFont(font);
        ((XYStyler)chart.getStyler()).setPlotGridLinesVisible(this.plotGridLinesVisible);
        ((XYStyler)chart.getStyler()).setYAxisTickMarkSpacingHint(15);
        ((XYStyler)chart.getStyler()).setXAxisLabelRotation(45);
        ((XYStyler)chart.getStyler()).setAxisTickMarkLength(15);
        ((XYStyler)chart.getStyler()).setPlotMargin(0);
        ((XYStyler)chart.getStyler()).setPlotContentSize(0.95);
        ((XYStyler)chart.getStyler()).setDatePattern("yyyy-MM-dd HH:mm:ss");
        ((XYStyler)chart.getStyler()).setChartTitleFont(new Font("Verdana", 1, 14));
        ((XYStyler)chart.getStyler()).setLegendFont(new Font("Verdana", 0, 12));
        ((XYStyler)chart.getStyler()).setAxisTitleFont(new Font("Verdana", 0, 12));
        ((XYStyler)chart.getStyler()).setAxisTickLabelsFont(new Font("Verdana", 0, 10));
        return chart;
    }

    private void plotAll(List<Date> xData, List<? extends Number> yData) throws IOException {
        XYChart chart = this.buildCommonChart();
        XYSeries series = chart.addSeries(SERIES_NAME, xData, yData);
        series.setLineColor(XChartSeriesColors.BLUE);
        series.setMarkerColor(Color.LIGHT_GRAY);
        series.setMarker(SeriesMarkers.NONE);
        series.setLineStyle(SeriesLines.SOLID);
        BitmapEncoder.saveBitmap((Chart)chart, (String)(this.baseName + "_rate.png"), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }

    public void plot(List<Date> xData, List<? extends Number> yData) throws IOException, MptEmptyDataSet {
        if (xData == null || xData.size() == 0) {
            throw new MptEmptyDataSet("The 'X' column data set is empty");
        }
        if (yData == null || yData.size() == 0) {
            throw new MptEmptyDataSet("The 'Y' column data set is empty");
        }
        this.plotAll(xData, yData);
    }

    public void setOutputWidth(int outputWidth) {
        this.outputWidth = outputWidth;
    }

    public void setOutputHeight(int outputHeight) {
        this.outputHeight = outputHeight;
    }

    public void setPlotGridLinesVisible(boolean plotGridLinesVisible) {
        this.plotGridLinesVisible = plotGridLinesVisible;
    }
}

