/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mdp.plot;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.orpiske.mdp.plot.Processor;
import net.orpiske.mdp.plot.RateData;
import net.orpiske.mdp.plot.RateInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateDataProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(RateDataProcessor.class);
    private Map<String, RateInfo> cache = new HashMap<String, RateInfo>();
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private long errorCount = 0L;

    @Override
    public void process(String eta, String ata) {
        int indexLen = 19;
        try {
            String period = ata.substring(0, 19);
            RateInfo rateInfo = this.cache.get(period);
            if (rateInfo == null) {
                Date ataDate = this.formatter.parse(ata);
                rateInfo = new RateInfo(ataDate, 1);
                this.cache.put(period, rateInfo);
            } else {
                int i = rateInfo.getCount();
                assert (++i >= 0);
                rateInfo.setCount(i);
            }
        }
        catch (ParseException e) {
            logger.warn("Error parsing record with values {},{}: {}", new Object[]{eta, ata, e.getMessage()});
            ++this.errorCount;
        }
    }

    public RateData getRateData() {
        RateData rateData = new RateData();
        this.cache.forEach((ratePeriod, rateInfo) -> rateData.add((RateInfo)rateInfo));
        rateData.setErrorCount(this.errorCount);
        return rateData;
    }
}

