/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mdp.plot;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import net.orpiske.mdp.plot.RateInfo;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class RateData {
    private Set<RateInfo> rateInfos = new TreeSet<RateInfo>();
    private SummaryStatistics statistics;
    private long errorCount;
    private long skipCount = 0L;

    public void add(RateInfo rateInfo) {
        this.rateInfos.add(rateInfo);
    }

    public List<Date> getRatePeriods() {
        ArrayList<Date> list = new ArrayList<Date>(this.rateInfos.size());
        this.rateInfos.forEach(item -> list.add(item.getPeriod()));
        return list;
    }

    public List<Integer> getRateValues() {
        return this.rateInfos.stream().mapToInt(RateInfo::getCount).boxed().collect(Collectors.toList());
    }

    private void processRateValues(IntConsumer rateValue) {
        this.rateInfos.stream().mapToInt(RateInfo::getCount).forEach(rateValue);
    }

    private void prepareStatistics() {
        if (this.statistics == null) {
            this.statistics = new SummaryStatistics();
            this.processRateValues(arg_0 -> ((SummaryStatistics)this.statistics).addValue(arg_0));
        }
    }

    public double getGeometricMean() {
        this.prepareStatistics();
        return this.statistics.getGeometricMean();
    }

    public double getMax() {
        this.prepareStatistics();
        return this.statistics.getMax();
    }

    public double getMin() {
        this.prepareStatistics();
        return this.statistics.getMin();
    }

    public double getStandardDeviation() {
        this.prepareStatistics();
        return this.statistics.getStandardDeviation();
    }

    public int getNumberOfSamples() {
        return this.rateInfos.size();
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    public long getSkipCount() {
        return this.skipCount;
    }

    public void setSkipCount(long skipCount) {
        this.skipCount = skipCount;
    }
}

