/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mdp.plot;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.orpiske.mdp.plot.Filter;
import net.orpiske.mdp.plot.Processor;
import net.orpiske.mdp.plot.RateData;
import net.orpiske.mdp.plot.RateInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredRateDataProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(FilteredRateDataProcessor.class);
    private Map<String, RateInfo> cache = new HashMap<String, RateInfo>();
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private long errorCount = 0L;
    private long skipCount = 0L;
    private Filter<Date> filter;

    public FilteredRateDataProcessor(Filter filter) {
        this.filter = filter;
    }

    @Override
    public void process(String eta, String ata) {
        int indexLen = 19;
        try {
            String period = ata.substring(0, 19);
            RateInfo rateInfo = this.cache.get(period);
            if (rateInfo == null) {
                Date ataDate = this.formatter.parse(ata);
                if (this.filter.eval(ataDate)) {
                    rateInfo = new RateInfo(ataDate, 1);
                    this.cache.put(period, rateInfo);
                } else {
                    ++this.skipCount;
                }
            } else {
                Integer i;
                Integer n = i = Integer.valueOf(rateInfo.getCount());
                Integer n2 = i = Integer.valueOf(i + 1);
                rateInfo.setCount(i);
            }
        }
        catch (ParseException e) {
            logger.warn("Error parsing record with values {},{}: {}", new Object[]{eta, ata, e.getMessage()});
            ++this.errorCount;
        }
    }

    public RateData getRateData() {
        RateData rateData = new RateData();
        for (RateInfo rateInfo : this.cache.values()) {
            rateData.add(rateInfo);
        }
        rateData.setErrorCount(this.errorCount);
        rateData.setSkipCount(this.skipCount);
        return rateData;
    }
}

