/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mdp.plot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import net.orpiske.mdp.plot.Processor;
import net.orpiske.mdp.plot.RateReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FastRateReader
implements RateReader {
    private static final Logger logger = LoggerFactory.getLogger(FastRateReader.class);
    public static final char SEPARATOR = ',';
    private final Processor processor;

    public FastRateReader(Processor processor) {
        this.processor = processor;
        logger.debug("Reading records using the fast rate reader");
    }

    @Override
    public void read(String fileName) throws IOException {
        Processor processor = this.processor;
        boolean compressed = fileName.endsWith(".gz");
        File file = new File(fileName);
        InputStream inputStream = compressed ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
        try (BufferedReader stream = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.US_ASCII));){
            String line;
            if (stream.readLine() == null) {
                return;
            }
            long samples = 0L;
            while ((line = stream.readLine()) != null) {
                int separatorIndex = line.indexOf(44);
                assert (separatorIndex != -1) : "Wrong separator";
                String start = line.substring(1, separatorIndex - 1);
                String end = line.substring(separatorIndex + 2, line.length() - 1);
                processor.process(start, end);
                ++samples;
            }
        }
    }
}

