/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mdp.plot;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import net.orpiske.mdp.plot.Processor;
import net.orpiske.mdp.plot.RateReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRateReader
implements RateReader {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRateReader.class);
    private Processor processor;

    public DefaultRateReader(Processor processor) {
        this.processor = processor;
        logger.debug("Reading records using the default rate reader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(String filename) throws IOException {
        FileInputStream fileStream = null;
        GZIPInputStream gzipStream = null;
        InputStreamReader in = null;
        long count = 0L;
        logger.debug("Reading file {}", (Object)filename);
        try {
            fileStream = new FileInputStream(filename);
            gzipStream = new GZIPInputStream(fileStream);
            in = new InputStreamReader(gzipStream);
            CSVParser records = CSVFormat.RFC4180.withCommentMarker('#').withFirstRecordAsHeader().withRecordSeparator(',').withQuote('\"').withQuoteMode(QuoteMode.NON_NUMERIC).parse((Reader)in);
            for (CSVRecord record : records) {
                this.processor.process(record.get(0), record.get(1));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(gzipStream);
            IOUtils.closeQuietly(fileStream);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(gzipStream);
        IOUtils.closeQuietly(fileStream);
    }
}

